
##############################################
### function to create a panel summarizing the arguments:
#
# 1) create the panel
# 2) add a heading for each section
# 3) add a paragraph with the section text
summarize.arguments.file = function(advAnalysisReport, arg.env, prb.annots)
{
  
  
  # Create the panel object that this function will return.
  argumentsPanel = panel(
    id = "arguments_panel", 
    title = "Summary of the options that were chosen when running this analysis.", 
    active = TRUE
  )
  
  
  # basic high-level choices:
  pg = ""
  pg = paste(pg,"Analysis name:",arg.env$advanced.analysis.name,"\n")
  pg = paste(pg,"Location of results:",arg.env$path.results.copy,"\n")
  #   pg = paste(pg,"Type of data:",data.type,"\n")
  pg = paste(pg,"File type of plots:",paste(unique(c("png",arg.env$plottypearg)),collapse=","),"\n")
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Analysis Details"),
    paragraph(content = pg)
  )
  
  
  #   # Low Count Threshold Details
  #   pg = ""
  #   pg = paste(pg,"Remove Genes Below Specified Threshold:",prunegenes.run,"\n")
  #   pg = paste(pg,"Threshold count value:",prunegenes.bg.level,"\n")
  #   pg = paste(pg,"Remove genes below the threshold at frequency greater than:",prunegenes.missing.freq,"\n")
  #   
  #   addReportContent(
  #     element = argumentsPanel,
  #     heading(content = "Low Count Threshold Details"),
  #     paragraph(content = pg)
  #   )
  
  # sample annotation details
  pg = ""
  pg = paste(pg,"Unique sample identifier:",arg.env$sample.annotation.id.column,"\n")
  for(i in 1:length(arg.env$sampleannot.variables))
  {
    pg = paste(pg,"Covariate",i,": ",arg.env$sampleannot.variables[i],"; Variable Type: ",arg.env$sampleannot.variabletypes[i],"; Reference Level: ",arg.env$sampleannot.referencelevels[i],"\n",sep="")
  }
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Sample Annotation Details"),
    paragraph(content = pg)
  )
  
  
  # gene annotation details
  pg = ""
  pg = paste(pg,"Column defining probe set membership:",arg.env$probe.set.column,"\n")
  pg = paste(pg,"Probe annotation column giving cell type-specific probes:",arg.env$probe.annotation.celltype.id.column,"\n")
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Gene Annotation Details"),
    paragraph(content = pg)
  )
  


  # normalization details:
  tmp <- arg.env$normmodule.nchoos
  pg = ""
  pg = paste(pg,"Perform normalization on:",ifelse(!is.null(arg.env$normmodule.analytes.run),arg.env$normmodule.analytes.run,"none"),"\n")
  pg = paste(pg,"Number of normalization probes:",ifelse(!is.null(tmp),paste(paste(names(unlist(tmp)),unlist(tmp),sep=": "),collapse = ", "),"NA"),"\n")
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Normalization Details"),
    paragraph(content = pg)
  )
  
  # pathway scoring details:
  pg = ""
  pg = paste(pg,"Perform pathway scoring analysis:",arg.env$pathscores.arg.run,"\n")
  pg = paste(pg,"Covariates to include in plots:",paste(ifelse(!is.null(arg.env$pathscores.arg.covariates),arg.env$pathscores.arg.covariates,"none"),collapse=", "),"\n")
  # <------------- need an argument for the path to the alternative cell tyep abundance
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Pathway Scoring Analysis Details"),
    paragraph(content = pg)
  )
  
  # DE details:
  pg = ""
  pg = paste(pg,"Perform differential expression testing:",arg.env$DEmodule.arg.run,"\n")
  pg = paste(pg,"Predictors:",paste(ifelse(!is.null(arg.env$DEmodule.arg.predictors),arg.env$DEmodule.arg.predictors,"none"),collapse=", "),"\n")
  pg = paste(pg,"Confounders:",paste(ifelse(!is.null(arg.env$DEmodule.arg.confounders),arg.env$DEmodule.arg.confounders,"none"),collapse=", "),"\n")
  pg = paste(pg,"P-value adjustment:",arg.env$DEmodule.arg.pval.adjustment,"\n")
  pg = paste(pg,"Run gene set analysis",gsamodule.arg.run,"\n")
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Differential Expression Analysis Details"),
    paragraph(content = pg)
  )
  
  
  # Pathview details:
  pg = ""
  pg = paste(pg,"Display results using Pathview:",arg.env$pathviewmodule.arg.run,"\n")
  pathviewmodule.arg.view.colorscheme2 = arg.env$pathviewmodule.arg.view.colorscheme
  if(arg.env$pathviewmodule.arg.view.colorscheme=="DE"){pathviewmodule.arg.view.colorscheme2 = "Fold-change"}
  if(arg.env$pathviewmodule.arg.view.colorscheme=="tstat"){pathviewmodule.arg.view.colorscheme2 = "t-statistic"}
  pg = paste(pg,"Color Pathview pathview plots by:",pathviewmodule.arg.view.colorscheme2,"\n")
  pg = paste(pg,"P-value threshold:",arg.env$pathviewmodule.arg.pvalthres,"\n")
  pg = paste(pg,"Additional KEGG IDs:",paste(ifelse(!is.null(arg.env$pathviewmodule.arg.keggIDs.custom),arg.env$pathviewmodule.arg.keggIDs.custom,"none"),collapse=", "),"\n")
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Pathview  Details"),
    paragraph(content = pg)
  )
  
  
  # cell type scoring details:
  pg = ""
  pg = paste(pg,"Perform immune cell type profiling:",arg.env$celltypes.arg.run,"\n")
  pg = paste(pg,"Covariates to include in plots:",paste(ifelse(!is.null(arg.env$celltypes.arg.covariates),arg.env$celltypes.arg.covariates,"none"),collapse=", "),"\n")
  pg = paste(pg,"Use all cell type genes or dynamically select a subset:",arg.env$celltypes.arg.geneselection,"\n")
  pg = paste(pg,"P-value threshold for reporting a cell type's results:",arg.env$celltypes.arg.pvalthreshold ,"\n")
  pg = paste(pg,"Show results at the level of raw cell type abundance:",arg.env$celltypes.arg.showraw,"\n")
  pg = paste(pg,"Show results at the level of relative cell type abundance:",arg.env$celltypes.arg.showrelative,"\n")
  pg = paste(pg,"Use default contrasts for calculating relative cell type abundance:",arg.env$celltypes.arg.usedefault,"\n")
  # <------------- need an argument for the path to the alternative cell tyep abundance
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Immune Cell Type Profiling Details"),
    paragraph(content = pg)
  )
  
  
  # Probe Descriptive details:
  pg = ""
  pg = paste(pg, "Run Probe Descriptive analysis:", arg.env$SPDarg.select.probe.analysis.run, "\n")
  
  if(arg.env$SPDarg.select.probe.analysis.run){
    
    i<-1
    for(prb.i in arg.env$SPDarg.probe.names.to.describe)
    {
      lab.prb.i <-  paste(prb.annots[as.character(prb.i),"Probe.Label"],prb.annots[as.character(prb.i),"Analyte.Type"],sep="-")
      pg = paste(pg, "probe name ",i,": ", lab.prb.i, "\n")
      i<-i+1
    }
    
    i<-1
    for(arg.i in arg.env$SPDarg.describe.probes.by)
    {
      pg = paste(pg, "Grouping variable ",i,": ", arg.i, "\n")
      i<- i+1
    }
    
    # Add trend plot arguments
    pg = paste(pg, "Interval ID:", ifelse(!is.null(arg.env$SPDarg.order.expression.trend.by),arg.env$SPDarg.order.expression.trend.by,"none"), "\n")
    pg = paste(pg, "Series ID:", ifelse(!is.null(arg.env$SPDarg.trend.expression.by),arg.env$SPDarg.trend.expression.by,"none"), "\n") 
    pg = paste(pg, "Stratifying variable:", ifelse(!is.null(arg.env$SPDarg.stratify.expression.trend.by),arg.env$SPDarg.stratify.expression.trend.by,"none"), "\n")
    
    # Add interaction network arguments
    pg = paste(pg, "Generate Interaction Network:", ifelse(isTRUE(arg.env$SPDarg.interactnet.run),"Yes","No"), "\n")
    pg = paste(pg, "Adjust Interaction Network:", ifelse(!is.null(arg.env$SPDarg.interactnet.adjustfor),arg.env$SPDarg.interactnet.adjustfor,"none"), "\n") 
    

  }
  
  addReportContent(
    element = argumentsPanel,
    heading(content = "Probe Descriptive Analysis Details"),
    paragraph(content = pg)
  )
  
  
  # Related Analytes
  pg <- ""
  pg = paste(pg, "Related Analytes Analysis:", arg.env$RPDarg.run, "\n")

    if(arg.env$RPDarg.run){

      i<-1
      for(prb.i in arg.env$RPDarg.probe.pairs.to.describe)
      {
        lab.prb.i <-  paste(prb.annots[as.character(prb.i),"Probe.Label"],prb.annots[as.character(prb.i),"Analyte.Type"],sep="-")
        pg = paste(pg, "probe name ",i,": ", lab.prb.i,"and its related analytes", "\n")
        i<-i+1
      }

      i<-1
      for(arg.i in arg.env$RPDarg.describe.probes.by)
      {
        pg = paste(pg, "Grouping variable ",i,": ", arg.i, "\n")
        i<- i+1
      }
      
      # Add trend plot arguments
      pg = paste(pg, "Interval ID:", ifelse(!is.null(arg.env$RPDarg.order.expression.trend.by),arg.env$RPDarg.order.expression.trend.by,"none"), "\n")
      pg = paste(pg, "Series ID:", ifelse(!is.null(arg.env$RPDarg.trend.expression.by),arg.env$RPDarg.trend.expression.by,"none"), "\n")
      pg = paste(pg, "Stratifying variable:", ifelse(!is.null(arg.env$RPDarg.stratify.expression.trend.by),arg.env$RPDarg.stratify.expression.trend.by,"none"), "\n")


    }
  
  
    addReportContent(
      element = argumentsPanel,
      heading(content = "Related Analytes Analysis Details"),
      paragraph(content = pg)
    )
  
  
  return(argumentsPanel)
}


# This function writes generates report for the universal adavanced analysis
write.univesal.analysis.report <- function(result,advAnalysisReport,prb.annots,arg.env){
  
  # bring elements of "result" into environment:
  names = names(result)
  for(i in 1:length(names))
  {
    assign(names[i],result[[names[i]]])
  }
  cat("document.write('<p>Writing analysis report</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
  
  #clean path.results for internet explorer:
  path.results = gsub("//","/",path.results)
  

  rawdata    <- annot.obj$rawdata
  annot      <- annot.obj$annot
  pannot     <- annot.obj$pannot
  annotcols  <- annot.obj$annotcols
  annotcols2 <- annot.obj$annotcols2
  sampleannot.variables       <- annot.obj$sampleannot.variables
  sampleannot.variabletypes   <- annot.obj$sampleannot.variabletypes
  sampleannot.referencelevels <- annot.obj$sampleannot.referencelevels
  probe.set.matrix <- annot.obj$prb.set.matrix
  
  
  # save the working directory 
  tempwd = getwd()
  
  
  # Add the Top Menu (The Module Menu) to the root of the report. The current stylesheet interpets the first
  # horizontal menu that is created as the main root object for the report.
  #-------------------------------------------------------------------------
  addReportContent(
    element = advAnalysisReport,
    
    #Add top module menu
    horizontalMenu(
      id = "moduleMenu",
      active = TRUE,
      
      #Add each menu "item" (button?) to the top menu. These can later be refered to by their IDs.
      menuItem(id = "moduleMenu_QC",  title = "Overview", active = QCmodule.arg.run, visible = QCmodule.arg.run),
      menuItem(id = "moduleMenu_Normalization", title = "Normalization", visible = !is.null(normmodule.analytes.run)),
      menuItem(id = "moduleMenu_PathwayScore",  title = "Pathway Score", visible = pathscores.arg.run),
      menuItem(id = "moduleMenu_DiffExpr", title = "Diff Expr", visible = DEmodule.arg.run),
      menuItem(id = "moduleMenu_GSA",  title = "GSA", visible = gsamodule.arg.run),
      menuItem(id = "moduleMenu_PathView", title = "PathView", visible = pathviewmodule.arg.run),
      menuItem(id = "moduleMenu_Celltype", title = "Immune Cell Type Profiling", visible = celltypes.arg.run, active = !QCmodule.arg.run),
      menuItem(id = "moduleMenu_SelectProbeDescriptive", title = "Probe Descriptive", visible = !is.null(result$SPD.dir)),
      menuItem(id = "moduleMenu_RelatedAnalytes", title = "Related Analytes", visible = !is.null(result$RPD.dir)),
      menuItem(id = "moduleMenu_Summary", title = "Analysis Parameters")
    )
    
  )
  
  
  #==============================
  #             Overview (QC)
  #==============================
  if(QCmodule.arg.run)
  {
    
    cat("document.write('<p>Writing Overview results </p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    print("writing Overview results")
    ### main tabs:
    # expression data: vertmenu: one tab for all data, on tab for each pathway. Each tab has 
    # - summary of whole dataset: heatmaps, PCA
    # - pathway level summaries
    
    # add a panel:
    addReportContent(
      element = getReportContentById(id = "moduleMenu_QC", report = advAnalysisReport),
      panel(id = "QCresultpanel",
            title = "This module generates a series of high level plots that describe the data overall and may be useful for identifying anomalous data and/or covariates."    
            )
    )
    
    # define the vert menu:
    buttonnames = c("Summary",colnames(probe.set.matrix))
    writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                 element.id="QCresultpanel",
                                 buttonnames=buttonnames,
                                 menuname="QCvertmenu",
                                 buttonprefix="QCbutton",
                                 panelsuffix="resultspanel",
                                 main.title="Plots exploring structure in the data",
                                 menu.title="Gene sets",
                                 makepanels=TRUE)
    
    # for all panels: add a horizontal menu with tabs for heatmaps and for PCA
    for(i in 1:length(buttonnames))
    {
      # add a horiz menu:
      addReportContent(
        element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
        horizontalMenu(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button", sep = ""),
                       title="Heatmaps", visible=TRUE)
      )
      # add a button for heatmaps:
      addReportContent(
        element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button", sep = ""), report = advAnalysisReport),  
        menuItem(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps", sep = ""),title = "Heatmaps", active=TRUE)
      )
      # add a panel for the heatmaps:
      addReportContent(
        element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps", sep = ""), report = advAnalysisReport),  
        panel(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""),title = buttonnames[i])    
      )
      
     heatmapAnnotation.1 = annotation(id = "heatmap_of_raw_data_count_annotation", "Heatmap of the raw counts. The plot is meant to provide an overview of how robust the raw expression levels are across samples and gene sets. Datasets that entirely lack higher level expressions (e.g. counts > 100) may indicate experimental failure or low input. The detected/undetected calls links to a .csv file stating whether each probe is above background, with 0/1 indicating below/above background. If the user has not specified a detection threshold, probes are called detected if they have more than double the counts of the median negative control.")
     heatmapAnnotation.2 = annotation(id = "heatmap_of_all_data_annotation", "Heatmap of the normalized data, scaled to give all genes equal variance, generated via unsupervised clustering. Orange indicates high expression; blue indicates low expression. This plot is meant to provide a high level exploratory view of the data.")
      #cormapAnnotation = annotation(id = "heatmap_of_cormat_of_all_data_annotation", "The Pearson correlation coefficient of gene expression is calculated between each set of samples to create a correlation matrix across all samples. Red indicates pairs of samples with highly correlated gene expression profiles, blue denotes lower correlations. Samples with high correlation have more similar gene expression profiles.")
      
      # for the summary tab:
      if(i==1)
      {
        # NEW heatmap of RAW data: 2/17/2016
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""), report = advAnalysisReport),  
          reportImage( 
            id = "heatmap of raw data counts",
            uri = paste(path.results,"/QC/raw data heatmap.png",sep=""),
            visible = file.exists( paste(path.results,"/QC/raw data heatmap.png",sep="") ),
            title = "Heatmap of Raw Data",
            fileDownloadLink(id="csv_Allnormed1", title="Detected/undetected calls", uri=paste0(path.results,"/QC/above background detection call.csv")),
            heatmapAnnotation.1,
            imageLegend(
              id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","-legend", sep = ""),
              uri = paste(path.results,"/QC/raw data heatmap - color key.png",sep=""))            
          )
        )
        # heatmap of all data:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""), report = advAnalysisReport),  
          reportImage(
            id = "heatmap of all data",
            uri = paste(path.results,"/QC/heatmap of all genes X samples.png",sep=""),
            visible = file.exists( paste(path.results,"/QC/heatmap of all genes X samples.png",sep="") ),
            title = "Heatmap of All Data",
            heatmapAnnotation.2,
            imageLegend(
              id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","-legend", sep = ""),
              uri = paste(path.results,"/color legend.png",sep=""))            
          )
        )
        #         # heatmap of correlation matrix:
        #         addReportContent(
        #           element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""), report = advAnalysisReport),  
        #           reportImage(
        #             id = "heatmap of cormat of all data",
        #             uri = paste(path.results,"/QC/correlation between samples - heatmap.png",sep=""),
        #             title = "Correlation Matrix of All Samples - Calculated from All Genes",
        #             cormapAnnotation,
        #             imageLegend(
        #               id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","-legend", sep = ""),
        #               uri = paste(path.results,"/color legend.png",sep=""))
        #           )
        #         )
        
      }
      
      # for gene set-specific results:
      if(i>1)
      {
        # heatmap of all data:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""), report = advAnalysisReport),  
          reportImage(
            id = paste("heatmap",buttonnames[i]),
            uri = paste(path.results,"/QC/heatmap of data - ",make.names(buttonnames[i]),".png",sep=""),
            visible = file.exists(paste(path.results,"/QC/heatmap of data - ",make.names(buttonnames[i]),".png",sep="")),
            title = paste("Heatmap of",buttonnames[i],"Data"),
            heatmapAnnotation.2,
            imageLegend(
              id = paste("vertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_","panel - legend",sep = ""),
              visible = file.exists(paste(path.results,"/QC/heatmap of data - ",make.names(buttonnames[i]),".png",sep="")),
              uri = paste(path.results,"/color legend.png",sep=""))            
          )
        )
        #         # heatmap of correlation matrix:
        #         addReportContent(
        #           element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_heatmaps_panel", sep = ""), report = advAnalysisReport),  
        #           reportImage(
        #             id = paste("heatmap or cormat",buttonnames[i]),
        #             uri = paste(path.results,"/QC/correlation between samples - heatmap - ",make.names(buttonnames[i]),".png",sep=""),
        #             title = paste("Correlation Matrix of All Samples - Calculated from",buttonnames[i],"Genes"),
        #             cormapAnnotation,
        #             imageLegend(
        #               id = paste("vertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_","panel - legend",sep = ""),
        #               uri = paste(path.results,"/color legend.png",sep=""))            
        #           )
        #         )
        
      }
      
      pcaAnnotation = annotation(id="pca_annotation", "Principal component analysis maps high-dimensional datasets onto a smaller number of highly informative dimensions. Here, the first four principal components of the gene expression data are plotted against each other and colored by the values of the selected covariate. This plot may be used to identify clusters in the data and to identify variables associated with prominent signal in the data. Variables that are associated with these leading principal components should be considered in downstream analyses.")
      
      ## add a horizontal menu for the PCA plots:
      addReportContent(
        element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),  
        horizontalMenu(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown", sep = ""), title = "PCA")
      )
      
      # if there are multiple covariates, add a dropdown menu of coloring choices:
      if(dim(annot)[2]>=1)
      {
        
        # for each covariate, add a button, a panel, and a plot and a legend:
        for(j in 1:ncol(annot))
        {
          covariatename = colnames(annot)[j]
          # button:
          addReportContent(
            element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown", sep = ""), report = advAnalysisReport),  
            menuItem(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename, sep = ""), title = covariatename)
          )
          # panel:
          addReportContent(
            element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename, sep = ""), report = advAnalysisReport),  
            panel(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel", sep = ""))
          )
          # plot and legend:
          
          # PCA pairs plot: for all genes:
          if(i==1)
          {
            addReportContent(
              element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel", sep = ""), report = advAnalysisReport),  
              reportImage( 
                id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel - PCA of all genes",colnames(annot)[j], sep = ""),
                uri = paste(path.results,"/QC/PCA colored by ",colnames(annot)[j],".png",sep=""),
                visible = file.exists(paste(path.results,"/QC/PCA colored by ",colnames(annot)[j],".png",sep="")),
                title = paste("Principal Components of All Data"),
                pcaAnnotation,
                imageLegend(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel - legend",colnames(annot)[j], sep = ""),
                            uri = paste(path.results,"/color legend - ",colnames(annot)[j],".png",sep=""))
                
              )
            )
          }
          # PCA pairs plot: for a pathway:
          if(i>1)
          {
            addReportContent(
              element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel", sep = ""), report = advAnalysisReport),  
              reportImage(
                id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel - PCA pairs plot",colnames(annot)[j], sep = ""),
                uri = paste(path.results,"/QC/PCA colored by ",colnames(annot)[j]," - ",make.names(buttonnames[i]),".png",sep=""),
                visible = file.exists(paste(path.results,"/QC/PCA colored by ",colnames(annot)[j]," - ",make.names(buttonnames[i]),".png",sep="")),
                title = paste("Principal Components of",buttonnames[i],"Data"),
                pcaAnnotation,
                imageLegend(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel - legend",colnames(annot)[j], sep = ""),
                            uri = paste(path.results,"/color legend - ",colnames(annot)[j],".png",sep=""))
              )
            )
          }
          
          
          # if there are outliers, write the table:
          if(is.element("outliers in first 4 principal components.csv",dir(path.to.QC.results)))
          {
            ## Add the results table: 
            addReportContent(
              element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel", sep = ""), report = advAnalysisReport),  
              reportTable(
                id = paste("outliers table",sep=""),
                uri=paste(path.to.QC.results,"//outliers in first 4 principal components.csv",sep=""),
                visible = file.exists(paste(path.to.QC.results,"//outliers in first 4 principal components.csv",sep="")),
                title = "Outliers",
                annotation(id = "QC_outliers", title = "Table identifying outliers in the first four PCs of the data."))
            )
          }
          
        }
      }
      
      covariateAnnotation = annotation(id="covariateAnnotation", "Pairwise comparisons of all covariates in the analysis. The type of plot is dependent on the types of variables compared; A categorical vs. categorical covariate plot is shown as a bar chart of counts (Y axis). Continuous vs. categorical covariates generate a boxplot with whiskers denoting 1.5 IQR. Continuous vs. continuous covariates are compared via a scatter plot. Variables that are correlated with a biological variable of interest are potential confounders that may influence downstream analyses. Additionally, bar plots and histograms show the distributions of categorical and continuous variables, respectively.")
      
      #### further QC plots under the summary tab:
      if(i==1)
      {
        # add a horizontal menu for the covariate pairs plots:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),  
          horizontalMenu(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs_drop", sep = ""), title = "Study design")
        )
        
        # add a button for the covariate pairs plots:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs_drop", sep = ""), report = advAnalysisReport),  
          menuItem(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs", sep = ""),title = "Covariates")
        )
        
        # add a panel for the covariate pairs plots:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs", sep = ""), report = advAnalysisReport),  
          panel(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs_panel", sep = ""),title = buttonnames[i])    
        )
        
        # draw the univariate covariate plots:
        # find every plot in the QC folder that begins with "pairs plots of covariates":
        QCplots = dir(paste(path.results,"/QC",sep=""))
        QCprefixes = substr(QCplots,1,10)
        QCsuffixes = substr(QCplots,nchar(QCplots)-3,nchar(QCplots))
        QCuniplots = QCplots[(QCprefixes=="univariate")&(QCsuffixes==".png")]
        for(j in 1:length(QCuniplots))
        {
          addReportContent(
            element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs_panel", sep = ""), report = advAnalysisReport),  
            reportImage(
              id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","covariateuniplots",j,"panel - legend",colnames(annot)[j], sep = ""),
              uri = paste(path.results,"/QC/",QCuniplots[j],sep=""),
              visible = file.exists(paste(path.results,"/QC/",QCuniplots[j],sep="")),
              title = "",
              covariateAnnotation)
          )
        }
        
        # draw the covariate pairs plots:
        # find every plot in the QC folder that begins with "pairs plots of covariates" and ends in ".png":
        QCplots = dir(paste(path.results,"/QC",sep=""))
        QCprefixes = substr(QCplots,1,24)
        QCsuffixes = substr(QCplots,nchar(QCplots)-3,nchar(QCplots))
        QCpairsplots = QCplots[(QCprefixes=="pairs plot of covariates")&(QCsuffixes==".png")]
        # draw the covariate pairs plots:
        if(length(QCpairsplots)>0)
        {
          for(j in 1:length(QCpairsplots))
          {
            addReportContent(
              element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_covariate_pairs_panel", sep = ""), report = advAnalysisReport),  
              reportImage(
                id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_PCA_dropdown_",covariatename,"panel - plot",colnames(annot)[j], sep = ""),
                uri = paste(path.results,"/QC/",QCpairsplots[j],sep=""),
                visible = file.exists(paste(path.results,"/QC/",QCpairsplots[j],sep="")),
                title = "",
                covariateAnnotation)
            )
          }
        }    
        
        # add a horizontal menu for the covariate pairs plots:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),  
          horizontalMenu(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_drop", sep = ""), title = "Other QC")
        )  
        
        # add a button for the mean-var plot and the pval histograms:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_drop", sep = ""), report = advAnalysisReport),  
          menuItem(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC", sep = ""),title = "Other QC")
        )
        # add a panel for the mean-var plot and the pval histograms:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC", sep = ""), report = advAnalysisReport),  
          panel(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_panel", sep = ""),title = buttonnames[i])    
        )
        # add the mean var plot and the pval histograms:
        addReportContent(
          element = getReportContentById(id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_panel", sep = ""), report = advAnalysisReport),  
          # mean var plot:
          reportImage(
            id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_panel_meanvar", sep = ""),
            uri = paste(path.results,"/QC/","mean vs var for all genes.png",sep=""),
            visible = file.exists(paste(path.results,"/QC/","mean vs var for all genes.png",sep="")),
            title = "Variance vs. Mean normalized signal plot across all targets/probes",
            annotation(id="mean_vs_var_annotation", "Each gene's variance in the log-scaled, normalized data is plotted against its mean value across all samples. Highly variable genes are indicated by gene name. Housekeeping genes are color coded according to their use in (or omission from) normalization."),
            fileDownloadLink(id="mean_vs_var_data", title="Mean and Variance statistics across all genes", uri=paste(path.results,"/QC/QC module - Mean.Var.normalized.counts.csv",sep=""))
          ),
          # pval histograms:
          reportImage(
            id = paste("QCvertmenu","QCbutton",buttonnames[i],"button","_otherQC_panel_pvalhistograms", sep = ""),
            uri = paste(path.results,"/QC/","p-value histograms.png",sep=""),
            visible = file.exists(paste(path.results,"/QC/","p-value histograms.png",sep="")),
            title = "p-value distribution plots",
            annotation(id="pval_histograms_annotation", "For each covariate included in the analysis, a histogram of p-values testing each gene's univariate association with the chosen covariate is displayed. Covariates with largely flat histograms have minimal association with gene expression; covariates with histograms with significantly more mass on the left are either associated with the expression of many genes or are confounded with a covariate that is associated with the expression. Low p-values indicate strong evidence for an association.")
          )
        )
      }  
    }
  }

  
  # ==============================
  #       Normalization
  #===============================
  if(normmodule.arg.run)
  {
    print("writing normalization results")
    cat("document.write('<p>Writing normalization results </p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE) 
    #### Get the Normalization menu item by its ID and add content to it
    addReportContent(
      element = getReportContentById(id = "moduleMenu_Normalization", report = advAnalysisReport),
      # Add a panel - the current stylesheet groups each menu item's content into panels, so this is required by that 
      # implementation.
      panel(id = "panel_Normalization",title = "Displays plots that detail the impact of normalization on the data.")#panel
      )
    
    addReportContent(
      element = getReportContentById(id = "panel_Normalization", report = advAnalysisReport),
      horizontalMenu(id = "panel_Normalization_horizTab_Analyte", title = "Analyte", active = FALSE)
    )
    
    if(any(prb.annots$Analyte.Type == "mRNA") & !is.null(arg.env$normmodule.nchoos$mRNA)){
      # ADD DROP DOWN MENU for mRNA
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte", report = advAnalysisReport),
        menuItem(id = "panel_Normalization_horizTab_Analyte_mRNA", title = "mRNA")
      )
      
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_mRNA", report = advAnalysisReport),
        panel(id = "panel_Normalization_horizTab_Analyte_mRNA_panel", title = "tstmRNA")
      )
      
      # Add an image - HK selection details - pairwise variance - to the panel
      if(file.exists(paste(path.results,"/Normalization/HK selection details - pairwise variance.png",sep=""))){
        addReportContent(element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_mRNA_panel", report = advAnalysisReport),
                         reportImage(
                           id = "img_hkSelectPV", 
                           uri=paste(path.results,"/Normalization/HK selection details - pairwise variance.png",sep=""), 
                           title = "Pairwise Variance during HK Selection",
                           annotation(id = "img_hkSelectPV_annotation", title = "Displays the geNorm pairwise variation statistic after successive genes are removed. This statistic cannot be computed for the final two genes, which are therefore not displayed. The ideal normalization gene set will minimize the pairwise variation statistic.")
                         )
        )
      }

      # Add the mRNA normalization Quality plot
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_mRNA_panel", report = advAnalysisReport),
        reportImage(
          id = "img_mRNAExpNormalization",
          uri = paste(path.results,"/Normalization/gx normalization results.png",sep=""),
          title = "Normalization Summary: mRNA",
          annotation(id = "img_mRNAExpNormalization", title = "The lower the MSE of reference profile the higher quality of normalization. The more positive normalization factor, the higher counts were registered for the sample and vice versa"),
          fileDownloadLink(id="csv_Allnormed1", title="Log2 Normalized All Data", uri=paste(path.results,"/Normalization/ALL_normalized log2 data.csv",sep="")),
          fileDownloadLink(id="csv_mRNAnormed", title="Log2 Normalized mRNA Data", uri=paste(path.results,"/Normalization/normalized log2 data.csv",sep="")),
          fileDownloadLink(id="csv_hkSelectPV_annotation", title="Download HK Genes", uri=paste(path.results,"/Normalization/selected housekeepers.csv",sep=""))
          )
        )
      
      
    }#End mRNA normalization results
    
    
     
    if(any(prb.annots$Analyte.Type == "protein" & !is.null(arg.env$normmodule.nchoos$protein))){
      # ADD DROP DOWN MENU for protein
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte", report = advAnalysisReport),
        menuItem(id = "panel_Normalization_horizTab_Analyte_protein", title = "protein")
      )
      
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_protein", report = advAnalysisReport),
        panel(id = "panel_Normalization_horizTab_Analyte_protein_panel", title = "tstprotein")
      )
      
      # Add the protein normalizer selection
      if(file.exists( paste(path.results,"/Normalization/protein normalizer selection.png",sep=""))){
        addReportContent(
          element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_protein_panel", report = advAnalysisReport),
          reportImage(
            id = "img_protein_normalizer_selection",
            uri = paste(path.results,"/Normalization/protein normalizer selection.png",sep=""),
            title = "Probe stability: protein",
            annotation(id = "img_protein_normalizer_selection", title = "Mean absolute deviance (MAD) is a measure of stability of protein probes. Ideal proteins for normalization have low MAD")
          )
        )
      }

      
      
      # Add the protein normalization Quality plot
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_protein_panel", report = advAnalysisReport),
        reportImage(
          id = "img_proteinExpNormalization",
          uri = paste(path.results,"/Normalization/protein normalization results.png",sep=""),
          title = "Normalization Summary: protein",
          annotation(id = "img_proteinExpNormalization", title = "The lower the MSE of reference profile the higher quality of normalization. The more positive normalization factor, the higher counts were registered for the sample and vice versa"),
          fileDownloadLink(id="csv_Allnormed2", title="Log2 Normalized All Data", uri=paste(path.results,"/Normalization/ALL_normalized log2 data.csv",sep="")),
          fileDownloadLink(id="csv_proteinNormData", title="Log2 Normalized Protein Data", uri=paste(path.results,"/Normalization/Protein_normalized log2 data.csv",sep="")),
          fileDownloadLink(id="csv_proteinNormSelect", title="Download Normalizer Proteins", uri=paste(path.results,"/Normalization/proteins used in normalization.csv",sep=""))
        )
      )
      
      
      # Add the protein detection
      addReportContent(
        element = getReportContentById(id = "panel_Normalization_horizTab_Analyte_protein_panel", report = advAnalysisReport),
        reportImage(
          id = "img_proteinExp_Thresholded",
          uri = paste(path.results,"/Normalization/protein expression thresholded.png",sep=""),
          title = "Expression thresholded: protein",
          annotation(id = "img_proteinExp_Thresholded", title = "Log normalized expression thresholded to zero based on the by-lane background level")
        )
      )
      
      
      
    }#End protein normalization results
    
  }
  
  
  # ==============================
  #     Differential Expression
  #===============================
  if(DEmodule.arg.run)
  {
    print("writing DE results")
    cat("document.write('<p>Writing DE analysis results </p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    ##### create the report structure:
    writeCovariatesMenu(reportobject = advAnalysisReport,id.modulemenu="moduleMenu_DiffExpr",resultname="DE",
                        resultvarnames=colnames(DEresults$ests)[1:DEresults$npredictors],sampleannot.variables.to.use=DEmodule.arg.predictors,
                        sampleannot.variabletypes=sampleannot.variabletypes,sampleannot.referencelevels=sampleannot.referencelevels,annot=annot,
                        title="Genes are tested for differential expression in response to each selected covariate. For each gene, a single linear \n  regression is fit using all selected covariates to predict expression. This approach eliminates confounding due to measured\n  covariates and isolates the independent association of each covariate with gene expression, measuring each variable's\n  association with a gene after holding all other variables constant.",
                        newtermnames=NULL)
    #newtermnames=DEresults$newtermnames)
    
    
    ##### add content to the menu structure created above.  Each predictor variable (as defined by DEresults) corresponds to a panel.
    resultvarnames = dimnames(DEresults$ests)[[2]]#[1]
    for(i in 1:length(resultvarnames))
    {
      # check that there's a corresponding panel:
      tempname = resultvarnames[i]
      tempname2 = make.names(tempname)
      if(length(getReportContentById(id=paste("DE","-resultpanel-",tempname, sep = ""), report=advAnalysisReport))>0)
      {
        addReportContent(
          element = getReportContentById(id = paste("DE","-resultpanel-",tempname, sep = ""), report = advAnalysisReport),
          # Add an image to the panel
          reportImage(
            id = paste("DEvolcano",tempname), 
            uri=paste(path.results,"/DE/volcano plot",tempname2,".png",sep=""), 
            title = paste("Volcano Plot:",tempname),
            annotation(id = "DEvolcano_annotation", "Volcano plot displaying each gene's -log10(p-value) and log2 fold change with the selected covariate. Highly statistically significant genes fall at the top of the plot, and highly differentially expressed genes fall to either side. Green point colors and horizontal lines indicate various False Discovery Rate (FDR) thresholds. The 40 most statistically significant genes are named.")),
          
          ## Add the results table: 
          reportTable(
            id = paste("DE-1_Table",tempname,sep=""),
            uri=paste(path.results,"/DE/DE Results - ",tempname2,".csv",sep=""), 
            title = paste("DE Results:",tempname),
            annotation(id = "DE_Results_annotation", title = "Table presenting the most statistically significantly differentially expressed genes with the selected covariate. 'Estimated log fold-change' estimates a gene's differential expression. For categorical covariates, a gene is estimated to have 2^(log fold change) times its expression in baseline samples, holding all other variables in the analysis constant. If the covariate is continuous, for each unit increase in the selected covariate, a gene's expression is estimated to increase by 2^(log fold change)-fold, holding all other variables in the analysis constant. The 95% confidence interval for the log fold change is also presented, along with a p-value and an adjusted p-value or FDR if requested."),
            fileDownloadLink(id = paste("DE-1_FileLink",tempname,sep=""),
                             uri=paste(path.results,"/DE/DE Results - ",tempname2,".csv",sep=""),
                             title="Download CSV Data")),
          
          ## add the warnings paragraph:
          paragraph(DEresults$DE.warnings.paragraph)
        )
      }
    }
  }
  
  # ==============================
  #       Probeset Analysis
  #===============================
  if(gsamodule.arg.run)
  {
    print("writing GSA results")
    cat("document.write('<p>Writing gene set analysis results</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    # add a panel:
    addReportContent(
      element = getReportContentById(id = "moduleMenu_GSA", report = advAnalysisReport),
      panel(id = "GSAresultpanel",
            title = "The results of differential expression testing are summarized at the gene set level. Each gene set's most differentially expressed genes are identified, and the extent of differential expression in each gene set is summarized using a 'global significance score'.")
    )
    
   
    
    
    writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                 element.id="GSAresultpanel",
                                 buttonnames=c("Summary",colnames(probe.set.matrix)[ colSums(probe.set.matrix[rownames(DEresults$ests),])>0]),
                                 menuname="GSAvertmenu",buttonprefix="GSAbutton",panelsuffix="resultspanel",
                                 main.title="Gene set level summary of the differential expression results",
                                 menu.title="Gene sets",
                                 makepanels=FALSE)
    
    globalsigstatsplot.directed_annotation = annotation(id = "globalsigstatsplot.directed_annotation", title = "Table displaying each sample's global significance scores and directed global significance scores as defined in the heatmaps above. The global significance score is calculated as the square root of the mean squared t-statistic for the genes in a gene set, with t-statistics coming from the linear regression underlying our differential expression analysis. The directed global significance score is calculated as the square root of the mean signed squared t-statistic for the genes in a gene set, with t-statistics coming from the linear regression underlying our differential expression analysis.")
    
    # write summary tab (heatmaps of global sig stats):
    # if there's more than 1 covariate, make a heatmap:
    if(ncol(gsaresults$mean.abs.tstat)>1)
    {
      addReportContent(
        element = getReportContentById(id = paste("GSAvertmenu","GSAbutton","Summary", sep = ""), report = advAnalysisReport),
        # make a panel and add results to it:
        
        panel(
          id = "GSAsummarypanel",
          
          # add global sig stats plot:
          reportImage(
            id = paste("globalsigstatsplot"), 
            uri=paste(path.results,"/Gene set analysis/heatmap of global significance scores.png",sep=""), 
            title = "Global Significance Scores",
            annotation(id = "global_sig_stats_annotation", title = "Heatmap displaying each sample's global significance scores. Global significance statistics measure the extent of differential expression of a gene set's genes with a covariate, ignoring whether each gene within the set is up- or down-regulated. Orange denotes gene sets whose genes exhibit extensive differential expression with the covariate, blue denotes gene sets with less differential expression.")),
          
          # add directed global sig stats plot:
          reportImage(
            id = paste("globalsigstatsplot.directed"), 
            uri=paste(path.results,"/Gene set analysis/heatmap of directed global significance scores - directed.png",sep=""), 
            title = "Directed Global Significance Scores",
            annotation(id = "directed_sig_stats_annotation", title = "Heatmap displaying each sample's directed global significance scores. Directed global significance statistics measure the extent to which a gene set's genes are up- or down-regulated with the variable. Red denotes gene sets whose genes exhibit extensive over-expression with the covariate, blue denotes gene sets with extensive under-expression."))
        )
      )
    }
    
    if(ncol(gsaresults$mean.abs.tstat)>=1)
    {
      addReportContent(
        element = getReportContentById(id = paste("GSAvertmenu","GSAbutton","Summary", sep = ""), report = advAnalysisReport),
        # make a panel and add results to it:
        
        panel(
          id = "GSAsummarypanel",
          
          ## add global sig stats table:
          #reportTable(
          #  id = paste("globalsigstatsplot"), 
          #  uri=paste(path.results,"/Gene set analysis/global significance stats - mean abs t-stat.csv",sep=""), 
          #  title = "Global significance scores"),
          
          ## add directed global sig stats table:
          #reportTable(
          #  id = paste("globalsigstatsplot.directed"), 
          #  uri=paste(path.results,"/Gene set analysis/global significance stats - mean t-stat.csv",sep=""), 
          #  title = "Directed global significance scores")
          
          # add a table of directed and undirected global sig stats:
          reportTable(
            id = paste("globalsigstatsplot.directed"), 
            uri=paste(path.results,"/Gene set analysis/global significance stats - directed and undirected.csv",sep=""), 
            title = "Undirected and Directed global significance scores table",
            globalsigstatsplot.directed_annotation,
            fileDownloadLink(id = "globalsigstatsplot.directed.download",
                             uri=paste(path.results,"/Gene set analysis/global significance stats - directed and undirected.csv",sep=""),
                             title="Download CSV Data")              
          )
        )
      )
    }
    
    # for each gene set tab, make and populate a horizontal menu of covariates:
    for(i in 1:dim(probe.set.matrix)[2])
    {
      genesetname = colnames(probe.set.matrix)[i]
      ## only add results to the report if there are genes in the gene set:  (added 5-25-2016 by PD)
      if(colSums(probe.set.matrix[rownames(DEresults$ests),])[i]>0)
      {
        # add a horizontal menu:
        writeCovariatesMenu(reportobject = advAnalysisReport,id.modulemenu= paste("GSAvertmenu","GSAbutton",genesetname, sep = ""),
                            resultname=paste("GSA",genesetname,sep="_"),
                            resultvarnames=colnames(DEresults$ests)[1:DEresults$npredictors],sampleannot.variables.to.use=DEmodule.arg.predictors,
                            sampleannot.variabletypes=sampleannot.variabletypes,sampleannot.referencelevels=sampleannot.referencelevels,annot=annot,
                            title=paste("Differential expression results for",genesetname,"genes."),
                            newtermnames=NULL)
        #newtermnames=DEresults$newtermnames)
        
        # populate the horizontal menu:
        resultvarnames = colnames(DEresults$ests)[1:DEresults$npredictors]
        for(j in 1:length(resultvarnames))
        {
          # check that there's a corresponding panel:
          tempname = resultvarnames[j]
          tempname2 = make.names(tempname)
          #if(length(getReportContentById(id=paste("GSA",genesetname), report=advAnalysisReport))>0)
          if(length(getReportContentById(id=paste(paste("GSA",genesetname,sep="_"),"-resultpanel-",tempname, sep = ""), report=advAnalysisReport))>0)
          {
            addReportContent(
              element = getReportContentById(id = paste(paste("GSA",genesetname,sep="_"),"-resultpanel-",tempname, sep = ""), report = advAnalysisReport),
              # Add an image to the panel
              reportImage(
                id = paste("GSAvolcano",genesetname,tempname), 
                uri=paste(path.results,"/Gene set analysis/volcano plot - ",tempname2," - ",make.names(genesetname),".png",sep=""), 
                title = paste("Volcano Plot:",tempname),
                annotation(id = "GSAvolcano_annotation", title = "Volcano plot displaying each gene's -log10(p-value) and log2 fold change for the selected covariate. Highly statistically significant genes fall at the top of the plot, and highly differentially expressed genes fall to either side. Genes within the selected gene set are highlighted in blue. Green point colors and horizontal lines indicate various False Discovery Rate (FDR) thresholds.")),
              
              ## Add the results table: 
              reportTable(
                id = paste("GSA-1_Table",tempname,sep=""),
                uri=paste(path.results,"/Gene set analysis/Genes in ",make.names(genesetname)," - ",tempname2,".csv",sep=""), 
                title = paste("DE Results -",genesetname,"genes -",tempname),
                globalsigstatsplot.directed_annotation,
                fileDownloadLink(id = paste("GSA-1_Download",tempname,sep=""),
                                 uri=paste(path.results,"/Gene set analysis/Genes in ",make.names(genesetname)," - ",tempname2,".csv",sep=""), 
                                 title="Download CSV Data")              
              )
            )
          }
        }
      }
    }
  }
  
  
  
  #===============================
  #       Pathview Plots
  #===============================
  if(pathviewmodule.arg.run)
  {
    print("writing Pathview results")
    cat("document.write('<p>Writing Pathview results </p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    ##### create the report structure:
    writeCovariatesMenu(reportobject = advAnalysisReport,id.modulemenu="moduleMenu_PathView",resultname="pathview",
                        resultvarnames=colnames(DEresults$ests)[1:DEresults$npredictors],sampleannot.variables.to.use=DEmodule.arg.predictors,
                        sampleannot.variabletypes=sampleannot.variabletypes,sampleannot.referencelevels=sampleannot.referencelevels,annot=annot,
                        title="Pathview is used to overlay differential expression results on KEGG pathways",
                        newtermnames=NULL)
    #newtermnames=DEresults$newtermnames)
    
    ##### add content to the menu structure created above.  Each predictor variable (as defined by DEresults) corresponds to a panel.
    for(i in 1:length(resultvarnames))
    {
      # check that there's a corresponding panel:
      tempname = resultvarnames[i]
      tempname2 = make.names(resultvarnames[i])  # <----- changed 7-9
      if(length(getReportContentById(id=paste("pathview","-resultpanel-",tempname, sep = ""), report=advAnalysisReport))>0)
      {
        # Restrict report tabs to those KEGG pathways for which we have results generated
        #--------------------------------------------------------------------------------
        KEGG.graph.generated <- file.exists(paste(path.results,"/Pathview/", as.character(keggIDs),".",tempname2,".png",sep=""))
        pathviewmodule.arg.keggnames <- pathviewmodule.arg.keggnames[KEGG.graph.generated]
        keggIDs <- keggIDs[KEGG.graph.generated]
        
        # add a vertical menu:
        writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                     element.id=paste("pathview","-resultpanel-",tempname, sep = ""),
                                     buttonnames=pathviewmodule.arg.keggnames,
                                     #buttonnames=as.character(kegg.id.map.sub$KEGG.Name),
                                     menuname=paste("Pathviewvertmenu",tempname,sep="_"),
                                     buttonprefix="pathviewbutton",
                                     panelsuffix="resultspanel",
                                     main.title="Pathview plots overlaying differential expression results on KEGG pathways",
                                     menu.title="Pathways")
        # for each element of the menu, add results to the panel:
        for(j in 1:length(as.character(pathviewmodule.arg.keggnames)))   #  #kegg.id.map.sub$KEGG.Name
        {
          addReportContent(
            element = getReportContentById(id = paste(paste("Pathviewvertmenu",tempname,sep="_"),"pathviewbutton",as.character(pathviewmodule.arg.keggnames)[j],"resultspanel", sep = ""),
                                           report = advAnalysisReport),
            # Add an image to the panel
            reportImage(
              # id = paste("pathviewplot",tempname2,as.character(kegg.id.map.sub$KEGG.Name)[j],sep="_"), 
              id = paste("pathviewplot",tempname2,as.character(pathviewmodule.arg.keggnames)[j],sep="_"),
              #uri=paste(path.results,"/Pathview/", pathview.species, as.character(kegg.id.map.sub$KEGG.ID)[j],".",tempname2,".png",sep=""), 
              uri=paste(path.results,"/Pathview/", as.character(keggIDs)[j],".",tempname2,".png",sep=""), 
              title = "",
              annotation(id = "pathviewplot_annotation", title = "For each KEGG pathway, genes within the panel are mapped to the pathway and differential expression information is overlaid on the protein-based KEGG pathway image. Pathway nodes shown in white have no genes in the panel that map to them. Pathway nodes in grey have corresponding genes in the panel, however no significant differential expression is observed. Nodes in green denote downregulation relative to the selected baseline, whereas nodes in red denote upregulation relative to the selected baseline."))
          )
        }
      }
    }
  }
  
  #===============================
  #       Pathway Scoring
  #===============================
  if(pathscores.arg.run)
  {
    cat("document.write('<p>Writing pathway scoring results</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    print("writing pathway scoring results")
    # organization:
    # horiz menu: Summary, QC, covariates
    # vert menu: summary, signatures
    # add a panel:
    addReportContent(
      element = getReportContentById(id = "moduleMenu_PathwayScore", report = advAnalysisReport),
      panel(
        id = "Pathscoreresultpanel",
        title="Pathway scores condense each sample's gene expression profile into a small set of pathway scores. An experiment can then be explored through the lens of pathway scores instead of in the much higher-dimension lens of gene expression values. Pathway scores are fit using the first principal component of each gene set's data. They are oriented such that increasing score corresponds to mostly increasing expression (specifically, each pathway score has positive weights for at least half its genes).
        Summary plots explore the joint behavior of pathways, and Covariates plots compare pathway scores to covariates.")
      )
    
    # add three horizontal menus: QC, Summary, Covariates
    addReportContent(
      element = getReportContentById(id = "Pathscoreresultpanel", report = advAnalysisReport),
      
      #Add each menu... when next to each other, these get rendered like "drop-down buttons"
      #     horizontalMenu(id = "pathscorehorizmenuitem_QC_dropdownmenu", title = "QC", active = FALSE),
      horizontalMenu(id = "pathscorehorizmenuitem_Summary_dropdownmenu", title = "Summary", active = TRUE),
      horizontalMenu(id = "pathscorehorizmenuitem_covariates_dropdownmenu", title = "Covariates", active = FALSE, visible = (!is.na(pathscores.arg.covariates[1])))
    )
    
    ## for each of raw, relative, make a menuitem, a panel, and draw results:
    # added here 6-9:
    rawrel = "score"  #names(celltypescoreslist)
    RawRel = "score"   #c("Raw","Relative")[is.element(c("raw","relative"),rawrel)]
    
    for(t in 1:length(rawrel))
    {
      # add a button:
      addReportContent(
        element = getReportContentById(id ="pathscorehorizmenuitem_Summary_dropdownmenu", report = advAnalysisReport),
        menuItem(id = paste("pathscorehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],sep=""), title = RawRel[t])
      )
      # add a panel:
      addReportContent(
        element = getReportContentById(id =paste("pathscorehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],sep=""), report = advAnalysisReport),
        panel(id = paste("pathscorehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],"_panel",sep=""), title = RawRel[t])
      )
      
      #now add a vert. menu:
      buttonnames = c("Summary",colnames(probe.set.matrix))
      writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                   element.id=paste("pathscorehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],"_panel",sep=""),
                                   buttonnames=buttonnames,menuname=paste("vertmenu",rawrel[t]),buttonprefix="pathscoresummarybutton",panelsuffix="resultspanel",
                                   main.title="titlepathscore1",
                                   menu.title="Choose a Pathway",
                                   makepanels=TRUE)
      
      # in the summary panel:  
      existingplots = dir(paste(path.results,"/pathway scoring",sep=""))
      
      if(is.element(paste("heatmap of signatures",".png",sep=""),existingplots))
      {
        addReportContent(
          element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"pathscoresummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
          
          # Add an image: heatmap of pathscore scores:
          reportImage(
            id = paste("pathscore heatmap",t,sep=""), 
            uri=paste(path.results,"/pathway scoring/heatmap of signatures",".png",sep=""), 
            title = paste("Heatmap of Pathway scores"),
            fileDownloadLink(id="pathway scores csv", title="Download Pathway scores", uri=paste(path.results,"/pathway scoring/signature scores",".csv",sep="")),
            imageLegend(id = paste("pathscoreheatmapcovariateslegend",t),
                        uri = paste(path.results,"/color legend.png",sep="")),
            annotation(id = paste("Pathway ",RawRel[t]," heatmap",sep=""), 
                       title = paste("Heatmap showing pathway ",rawrel[t],". This plot is a high level overview of how the pathway scores change across samples. Use it to understand how which pathway scores cluster together and which samples exhibit similar pathway score profiles. Orange indicates high scores; blue indicates low scores. Scores are displayed on the same scale via a Z-transformation.",sep="")))
        )
      }
      
      # Add an image: heatmap of cormat of pathscore scores:
      if(is.element(paste("signatures correlation heatmap",".png",sep=""),existingplots))
      {
        addReportContent(
          element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"pathscoresummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
          
          reportImage(
            id = paste("pathscore cormat heatmap",t,sep=""),
            uri=paste(path.results,"/pathway scoring/signatures correlation heatmap",".png",sep=""), 
            title = "Heatmap of Correlation Matrix of Pathway scores",
            annotation(id = "Correlation matrix of Pathway scores heatmap", 
                       title = paste("Heatmap showing the correlation matrix of pathway scores. Red and blue indicate positive and negative correlation, respectively.",sep="")))
        ) 
      }
      
      
      # write results for all cell types:
      for(i in 2:length(buttonnames))
      {
        # loop through covariates:  <---------
        for(j in 1:length(pathscores.arg.covariates))
        {
          includeLegend = FALSE
          if(is.na(pathscores.arg.covariates[1])) {
            plotUri = paste(path.results,"/pathway scoring/signatures pairs plot"," - ",buttonnames[i],".png",sep="")
          } else {
            plotUri = paste(path.results,"/pathway scoring/signatures pairs plot"," - ",buttonnames[i]," - colored by ",pathscores.arg.covariates[j],".png",sep="")
            includeLegend = TRUE
          }
          
          # Add an image: pathscore pairs plot:
          addReportContent(element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"pathscoresummarybutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
                           reportImage(
                             id = paste("pathscore pairs plot",rawrel[t],i,"_",j), 
                             uri=plotUri, 
                             title = paste(buttonnames[i],"measurements vs. other pathway scores"),
                             imageLegend(id = paste("pathscore pairs plot legend",rawrel[t],i,"_",j), 
                                         uri=paste(path.results,"/color legend - ",pathscores.arg.covariates[j],".png",sep=""), visible=includeLegend),
                             annotation(id = paste("Cell type ",RawRel[t]," abundance pairs",sep=""), 
                                        title = paste("Each panel plots ",buttonnames[i]," against another pathway score.  Points are colored by ",pathscores.arg.covariates[j],".",sep="")))
          )
          
          if (length(pathscores.arg.covariates) == 0) { 
            break 
          }
        }
      }
    }
    #    ## add QC button - turned off for Pathway scoring - need to revisit - jbucci 4/12/2016
    #    addReportContent(
    #      element = getReportContentById(id ="pathscorehorizmenuitem_QC_dropdownmenu", report = advAnalysisReport),
    #      menuItem(id = "pathscorehorizmenuitem_QC_dropdownmenu_button", title = "QC")
    #    )  
    #    ## cell types QC panel: only raw scores shown:
    #    addReportContent(
    #      element = getReportContentById(id = "pathscorehorizmenuitem_QC_dropdownmenu_button", report = advAnalysisReport),
    #      panel(id = "pathscorehorizmenuitem_QC_panel")
    #    )
    #    #now add a vert. menu, with a button for each cell type with results:
    #    QCplots = dir(paste(path.results,"/Cell types",sep=""))
    #    QCprefixes = substr(QCplots,1,21)
    #    QCsuffixes = substr(QCplots,22,nchar(QCplots)-4)
    #    is.qc.plot = QCprefixes=="QC for cell scores - "
    #  
    #    #buttonnames = c(colnames(celltypescoreslist[[1]]))
    #    buttonnames = QCsuffixes[is.qc.plot]
    #    writeandpopulateverticalmenu(reportobject = advAnalysisReport,
    #                                 element.id="celltypehorizmenuitem_QC_panel",
    #                                 buttonnames=buttonnames,menuname=paste("QCvertmenu"),buttonprefix="cellQCbutton",panelsuffix="resultspanel",
    #                                 main.title="titlecelltype3",
    #                                 menu.title="Choose a Cell Type",
    #                                 makepanels=TRUE)
    #    # now fill in results for each panel created in the above vert menu:
    #    for(i in 1:length(buttonnames))
    #    {
    #      # Add an image: celltype pairs plot:
    #      addReportContent(element = getReportContentById(id = paste("QCvertmenu","cellQCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
    #                       reportImage(
    #                         id = paste("celltype QC plot",i), 
    #                         uri=paste(path.results,"/cell types/QC for cell scores - ",buttonnames[i],".png",sep=""), 
    #                         title = paste("QC Plot for Cell Type Measurements:",buttonnames[i]),
    #                         annotation(id = paste("celltype QC plot",i), 
    #                                    title = paste("Normalized expression of the genes characteristic of ",buttonnames[i],".  
    #                                                  If a cell type's characteristic genes are specific to the cell type and stably expressed within it, they will be strongly correlated with a slope of 1. Substantial departures from this pattern indicate noisier quantification of cell type abundance.",sep="")))
    #      )
    #    }
    
    ####
    ####
    if(length(pathscores.arg.covariates)>0)
    {
      ## for each of raw, relative, make a menuitem, a panel, and draw results:
      # added here 6-9:
      #rawrel = c("raw","relative")[c(pathscores.arg.showraw,pathscores.arg.showrelative)]
      #RawRel = c("Raw","Relative")[c(pathscores.arg.showraw,pathscores.arg.showrelative)]
      rawrel = "score"      #names(celltypescoreslist)
      RawRel = "score"      #c("Raw","Relative")[is.element(c("raw","relative"),rawrel)]
      # added here 6-9:
      for(t in 1:length(rawrel))
      {
        # add a button:
        addReportContent(
          element = getReportContentById(id ="pathscorehorizmenuitem_covariates_dropdownmenu", report = advAnalysisReport),
          menuItem(id = paste("pathscorehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],sep=""), title = RawRel[t])
        )
        # add a panel:
        addReportContent(
          element = getReportContentById(id =paste("pathscorehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],sep=""), report = advAnalysisReport),
          panel(id = paste("pathscorehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],"_panel",sep=""), title = RawRel[t])
        )
        
        #now add a vert. menu:
        buttonnames = c("Summary",colnames(probe.set.matrix))
        writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                     element.id=paste("pathscorehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],"_panel",sep=""),
                                     buttonnames=buttonnames,menuname=paste("vertmenu",rawrel[t]),buttonprefix="covariatessummarybutton",panelsuffix="resultspanel",
                                     main.title="titlepathscore5",
                                     menu.title="Choose a Pathway",
                                     makepanels=TRUE)
        
        ## draw plots in the summary panel:  
        # loop through covariates:  
        for(j in 1:length(pathscores.arg.covariates))
        {
          addReportContent(
            element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"covariatessummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
            
            # Add an image: heatmap of pathway scores:
            reportImage(
              id = paste("pathscore vs covariates trendplot",j,sep=""), 
              uri=paste(path.results,"/pathway scoring/trend plot of signatures vs. ",pathscores.arg.covariates[j],".png",sep=""), 
              title = paste("Pathway scores vs.",pathscores.arg.covariates[j]),
              annotation(id = paste("Pathway scores vs. ",pathscores.arg.covariates[j],sep=""), 
                         title = paste("Plots the pathway scores against ",pathscores.arg.covariates[j],"."," The pathway scores are plotted to show how they vary across different values of ",pathscores.arg.covariates[j]," conditions. Lines show each pathway's average score across values of ",pathscores.arg.covariates[j],".",sep="")))    
          )
        }
        
        ## now draw results for each pathway:
        for(i in 2:length(buttonnames))
        {
          # loop through covariates:  
          for(j in 1:length(pathscores.arg.covariates))
          {
            # Add an image: pathscore pairs plot:
            addReportContent(element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"covariatessummarybutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
                             reportImage(
                               id = paste("pathscore covariates plot",rawrel[t],i,j,sep="_"), 
                               uri=paste(path.results,"/pathway scoring/",buttonnames[i]," pathway scores vs. ",pathscores.arg.covariates[j],".png",sep=""),
                               title = paste(buttonnames[i]," pathway scores vs.",pathscores.arg.covariates[j]),
                               annotation(id = paste(buttonnames[i]," pathway scores vs. ",pathscores.arg.covariates[j],sep=""), 
                                          title = paste("Plots ",buttonnames[i]," pathway scores against ",pathscores.arg.covariates[j],".",sep="")))
            )
          }
        } 
      } 
    }
  }
  
  
  
  # ==============================
  #       Cell type Profiling
  #===============================
  if(celltypes.arg.run)
  {
    cat("document.write('<p>Writing immune cell type profiling results</p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
    print("writing cell type results")
    # organization:
    # horiz menu: Summary (raw/relative), QC, covariates (raw/relative), 
    # vert menu: summary, cell types (raw or relative depending on horiz menu choice)
    # add a panel:
    addReportContent(
      element = getReportContentById(id = "moduleMenu_Celltype", report = advAnalysisReport),
      panel(
        id = "Celltyperesultpanel",
        title="Genes previously shown to be characteristic of various immune cell populations are used to measure these populations' abundance.
        QC plots explore the validity of each cell type's measurements, Summary plots explore the joint behavior of cell types, and Covariates plots compare cell type measurements to covariates.
        In addition to raw cell type abundance measurements, relative abundances measuring various contrasts between cell types are reported.")
      )
    
    # add three horizontal menus: QC, Summary, Covariates
    addReportContent(
      element = getReportContentById(id = "Celltyperesultpanel", report = advAnalysisReport),
      
      #Add each menu... when next to each other, these get rendered like "drop-down buttons"
      horizontalMenu(id = "celltypehorizmenuitem_QC_dropdownmenu", title = "QC", active = TRUE),
      horizontalMenu(id = "celltypehorizmenuitem_Summary_dropdownmenu", title = "Summary", active = FALSE, visible = (arg.env$celltypes.arg.showrelative | arg.env$celltypes.arg.showraw) ),
      horizontalMenu(id = "celltypehorizmenuitem_covariates_dropdownmenu", title = "Covariates", active = FALSE, visible = (!is.na(celltypes.arg.covariates[1])) & (arg.env$celltypes.arg.showrelative | arg.env$celltypes.arg.showraw) )
    )
    
    
    ## for each of raw, relative, make a menuitem, a panel, and draw results:
    # added here 6-9:
    #rawrel = c("raw","relative")[c(celltypes.arg.showraw,celltypes.arg.showrelative)]
    #RawRel = c("Raw","Relative")[c(celltypes.arg.showraw,celltypes.arg.showrelative)]
    rawrel = names(celltypescoreslist)
    RawRel = c("Raw","Relative")[is.element(c("raw","relative"),rawrel)]
    # added here 6-9:
    
    # add a switch to turn off display raw or relative when only one selected
    display.type.t <- c(raw = arg.env$celltypes.arg.showraw, relative = arg.env$celltypes.arg.showrelative)
 
    for(t in 1:length(rawrel))
    {
      # skip if the current display type is not to be shown
      #-----------------------------------------------------
      if(!display.type.t[rawrel[t]])
        next
        
      # add a button:
      addReportContent(
        element = getReportContentById(id ="celltypehorizmenuitem_Summary_dropdownmenu", report = advAnalysisReport),
        menuItem(id = paste("celltypehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],sep=""), title = RawRel[t])
      )
      # add a panel:
      addReportContent(
        element = getReportContentById(id =paste("celltypehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],sep=""), report = advAnalysisReport),
        panel(id = paste("celltypehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],"_panel",sep=""), title = RawRel[t])
      )
      
      #now add a vert. menu:
      
      if(is.na(celltypes.arg.covariates[1])){
        existing.pair.plots <- file.exists(paste(path.results,"/cell types/cell scores pairs plot - ",rawrel[t]," - ",colnames(celltypescoreslist[[t]]),".png",sep=""))
      }else{
        existing.pair.plots <- rep(T,ncol(celltypescoreslist[[t]]))
        for(cov.i in celltypes.arg.covariates){
          existing.pair.plots <- existing.pair.plots & file.exists(paste(path.results,"/cell types/cell scores pairs plot - ",rawrel[t]," - ",colnames(celltypescoreslist[[t]])," - colored by ",cov.i,".png",sep=""))
        }
        
      }

      buttonnames = c("Summary",colnames(celltypescoreslist[[t]])[existing.pair.plots])
      #buttonnames = c("Summary",colnames(celltypescoreslist[[t]]))

      writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                   element.id=paste("celltypehorizmenuitem_Summary_dropdownmenu_button_",rawrel[t],"_panel",sep=""),
                                   buttonnames=buttonnames,
                                   menuname=paste("vertmenu",rawrel[t]),
                                   buttonprefix="cellsummarybutton",
                                   panelsuffix="resultspanel",
                                   main.title="titlecelltype1",
                                   menu.title="Choose a Cell Type",
                                   makepanels=TRUE)
      
      # in the summary panel:  
      existingplots = dir(paste(path.results,"/cell types",sep=""))
      
      if(is.element(paste("heatmap of cell types scores - ",rawrel[t],".png",sep=""),existingplots))
      {
        addReportContent(
          element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"cellsummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
          
          # Add an image: heatmap of celltype scores:
          reportImage(
            id = paste("celltype heatmap",t,sep=""), 
            uri=paste(path.results,"/cell types/heatmap of cell types scores - ",rawrel[t],".png",sep=""), 
            title = paste("Heatmap of",RawRel[t],"cell type measurements"),
            fileDownloadLink(id=paste("cell type csv",rawrel[t]), title=paste("Download",rawrel[t],"cell type measurements"), uri=paste(path.results,"/cell types/cell type scores - ",rawrel[t],".csv",sep="")),
            imageLegend(id = paste("celltypeheatmapcovariateslegend",t),
                        uri = paste(path.results,"/color legend.png",sep="")),
            annotation(id = paste("Cell type ",RawRel[t]," abundance heatmap",sep=""), 
                       title = paste("Heatmap showing ",rawrel[t]," abundance of immune cell types. Orange indicates high abundance; blue indicates low abundance. Note that our methods do not support the conclusion that one cell type is more abundant than another.  Rather, they support the claim that a given cell type is more abundant in one sample than in another.",sep="")))
        )
      }
      
      # Add an image: heatmap of cormat of celltype scores:
      if(is.element(paste("cell type scores correlation heatmap - ",rawrel[t],".png",sep=""),existingplots))
      {
        addReportContent(
          element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"cellsummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
          
          reportImage(
            id = paste("celltype cormat heatmap",t,sep=""),
            uri=paste(path.results,"/cell types/cell type scores correlation heatmap - ",rawrel[t],".png",sep=""), 
            title = paste("Heatmap of Correlation Matrix of",RawRel[t],"cell type measurements"),
            annotation(id = paste("Correlation matrix of cell type ",RawRel[t]," abundance heatmap",sep=""), 
                       title = paste("Heatmap showing the correlation matrix of ",rawrel[t]," immune cell abundance. Red and blue indicate positive and negative correlation, respectively.",sep="")))
        ) 
      }
      
      
      # write results for all cell types:
      for(i in 2:length(buttonnames))
      {
        # loop through covariates:  <---------
        for(j in 1:length(celltypes.arg.covariates))
        {
          includeLegend = FALSE
          if(is.na(celltypes.arg.covariates[1])) {
            plotUri = paste(path.results,"/cell types/cell scores pairs plot - ",rawrel[t]," - ",buttonnames[i],".png",sep="")
          } else {
            plotUri = paste(path.results,"/cell types/cell scores pairs plot - ",rawrel[t]," - ",buttonnames[i]," - colored by ",celltypes.arg.covariates[j],".png",sep="")
            includeLegend = TRUE
          }
          
          
          if(file.exists(plotUri)){
            # Add an image: celltype pairs plot:
            addReportContent(element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"cellsummarybutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
                             reportImage(
                               id = paste("celltype pairs plot",rawrel[t],i,"_",j), 
                               uri=plotUri, 
                               title = paste(buttonnames[i],"measurements vs. other cell type measurements"),
                               imageLegend(id = paste("celltype pairs plot legend",rawrel[t],i,"_",j), 
                                           uri=paste(path.results,"/color legend - ",celltypes.arg.covariates[j],".png",sep=""), visible=includeLegend),
                               annotation(id = paste("Cell type ",RawRel[t]," abundance pairs",sep=""), 
                                          title = paste("Each panel plots ",buttonnames[i]," against another ",rawrel[t]," abundance measurements.  Points are colored by ",celltypes.arg.covariates[j],".",sep="")))
            )
          }

          
          if (length(celltypes.arg.covariates) == 0) { 
            break 
          }
        }      
      }
      
      
    }
    
    ## add QC button
    addReportContent(
      element = getReportContentById(id ="celltypehorizmenuitem_QC_dropdownmenu", report = advAnalysisReport),
      menuItem(id = "celltypehorizmenuitem_QC_dropdownmenu_button", title = "QC")
    )  
    ## cell types QC panel: only raw scores shown:
    addReportContent(
      element = getReportContentById(id = "celltypehorizmenuitem_QC_dropdownmenu_button", report = advAnalysisReport),
      panel(id = "celltypehorizmenuitem_QC_panel")
    )
    #now add a vert. menu, with a button for each cell type with results:
    QCplots = dir(paste(path.results,"/Cell types",sep=""))
    QCplots = QCplots[grep(pattern = "^.+[.]png$",x = QCplots)]
    QCprefixes = substr(QCplots,1,21)
    QCsuffixes = substr(QCplots,22,nchar(QCplots)-4)
    is.qc.plot = QCprefixes=="QC for cell scores - "
    
    #buttonnames = c(colnames(celltypescoreslist[[1]]))
    buttonnames = QCsuffixes[is.qc.plot]
    writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                 element.id="celltypehorizmenuitem_QC_panel",
                                 buttonnames=buttonnames,menuname=paste("QCvertmenu"),buttonprefix="cellQCbutton",panelsuffix="resultspanel",
                                 main.title="titlecelltype3",
                                 menu.title="Choose a Cell Type",
                                 makepanels=TRUE)
    # now fill in results for each panel created in the above vert menu:
    for(i in 1:length(buttonnames))
    {
      # Add an image: celltype pairs plot:
      addReportContent(element = getReportContentById(id = paste("QCvertmenu","cellQCbutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
                       reportImage(
                         id = paste("celltype QC plot",i), 
                         uri=paste(path.results,"/cell types/QC for cell scores - ",buttonnames[i],".png",sep=""), 
                         title = paste("QC Plot for Cell Type Measurements:",buttonnames[i]),
                         annotation(id = paste("celltype QC plot",i), 
                                    title = paste("Normalized expression of the genes characteristic of ",buttonnames[i],".  
                                                  If a cell type's characteristic genes are specific to the cell type and stably expressed within it, they will be strongly correlated with a slope of 1. Substantial departures from this pattern indicate noisier quantification of cell type abundance.",sep="")))
                                    )
    }
    
    if(length(celltypes.arg.covariates)>0)
    {
      ## for each of raw, relative, make a menuitem, a panel, and draw results:
      # added here 6-9:
      #rawrel = c("raw","relative")[c(celltypes.arg.showraw,celltypes.arg.showrelative)]
      #RawRel = c("Raw","Relative")[c(celltypes.arg.showraw,celltypes.arg.showrelative)]
      rawrel = names(celltypescoreslist)
      RawRel = c("Raw","Relative")[is.element(c("raw","relative"),rawrel)]
      # added here 6-9:



      for(t in 1:length(rawrel))
      {
        # skip if the current display type is not to be shown
        #-----------------------------------------------------
        if(!display.type.t[rawrel[t]])
          next
        
        # add a button:
        addReportContent(
          element = getReportContentById(id ="celltypehorizmenuitem_covariates_dropdownmenu", report = advAnalysisReport),
          menuItem(id = paste("celltypehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],sep=""), title = RawRel[t])
        )
        # add a panel:
        addReportContent(
          element = getReportContentById(id =paste("celltypehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],sep=""), report = advAnalysisReport),
          panel(id = paste("celltypehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],"_panel",sep=""), title = RawRel[t])
        )
        
        #now add a vert. menu:
        buttonnames = c("Summary",colnames(celltypescoreslist[[t]]))
        writeandpopulateverticalmenu(reportobject = advAnalysisReport,
                                     element.id=paste("celltypehorizmenuitem_covariates_dropdownmenu_button_",rawrel[t],"_panel",sep=""),
                                     buttonnames=buttonnames,menuname=paste("vertmenu",rawrel[t]),buttonprefix="covariatessummarybutton",panelsuffix="resultspanel",
                                     main.title="titlecelltype5",
                                     menu.title="Choose a Cell Type",
                                     makepanels=TRUE)
        
        ## draw plots in the summary panel:  
        # loop through covariates:  
        for(j in 1:length(celltypes.arg.covariates))
        {
          addReportContent(
            element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"covariatessummarybutton",buttonnames[1],"resultspanel", sep = ""), report = advAnalysisReport),
            
            # Add an image: heatmap of celltype scores:
            reportImage(
              id = paste("celltype vs covariates trendplot",j,sep=""), 
              uri=paste(path.results,"/cell types/trend plot of cell type scores vs. ",celltypes.arg.covariates[j]," - ",rawrel[t]," - legend.png",sep=""), 
              title = paste(RawRel[t],"cell type measurements vs.",celltypes.arg.covariates[j]),
              annotation(id = paste("Cell types vs. ",celltypes.arg.covariates[j],sep=""), 
                         title = paste("Plots the ",rawrel[t]," cell type abundance measurements against ",celltypes.arg.covariates[j],".",sep="")))    
          )
        }
        
        ## now draw results for each cell type:
        for(i in 2:length(buttonnames))
        {
          # loop through covariates:  
          for(j in 1:length(celltypes.arg.covariates))
          {
            # Add an image: celltype pairs plot:
            addReportContent(element = getReportContentById(id = paste(paste("vertmenu",rawrel[t]),"covariatessummarybutton",buttonnames[i],"resultspanel", sep = ""), report = advAnalysisReport),
                             reportImage(
                               id = paste("celltype covariates plot",rawrel[t],i,j,sep="_"), 
                               uri=paste(path.results,"/cell types/",celltypes.arg.covariates[j]," - ",rawrel[t]," - ",buttonnames[i],".png",sep=""), 
                               title = paste(buttonnames[i],"Measurement vs.",celltypes.arg.covariates[j]),
                               annotation(id = paste(buttonnames[i]," vs. ",celltypes.arg.covariates[j],sep=""), 
                                          title = paste("Plots ",buttonnames[i]," measurements against ",celltypes.arg.covariates[j],".",sep="")))
            )
          }
        } 
      } 
    }
    }
  
  
  # ==============================
  #       Probe Descriptive
  #===============================
  if(SPDarg.select.probe.analysis.run){
    print("writing Probe Descriptive results")
    source("./R_source/append_SPD_to_report.R")
    advAnalysisReport <- append.SPD.report(advAnalysisReport = advAnalysisReport,results.dir = result$SPD.dir,module.menue.name = "moduleMenu_SelectProbeDescriptive",prb.annots = prb.annots)
  }
  
  
  # ==============================
  #         Related Analytes
  #===============================
  if(RPDarg.run){
    print("writing Related Analytes Module results")
    source("./R_source/append_RPD_to_report.R")
    advAnalysisReport <- append.RPD.report(advAnalysisReport = advAnalysisReport,results.dir = result$RPD.dir,module.menue.name = "moduleMenu_RelatedAnalytes",prb.annots = prb.annots)
  }
  

  # ==============================
  #       Summary Parameters
  #===============================
  
  arguments.panel <- summarize.arguments.file(advAnalysisReport = advAnalysisReport, arg.env=arg.env, prb.annots= prb.annots)
  
  ## Add the warnings to the arguments panel
  addReportContent(
    element=arguments.panel,
    paragraph(warnings.paragraph)
  )
  
  ## Add the panel to the menu
  addReportContent(
    element = getReportContentById(id = "moduleMenu_Summary", report = advAnalysisReport),
    arguments.panel
  )
  
  
  #=========================================
  #       Render the HTML file
  #=========================================
  # Write out two output files. The first is just for development use, the second is the actual report output
  #Transform the object tree into XML and write to a file using the copy XSLT 
  writeReportHtml(
    report = advAnalysisReport,
    xsltPath = file.path(path.pipeline.base, "copy.xslt"),
    outputPath = file.path(analysis.path, "AdvAnalysisReport.xml"))
  
  writeReportHtml(
    report = advAnalysisReport,
    xsltPath = file.path(path.pipeline.base, "AdvAnalysisReport.xslt"),
    outputPath = file.path(analysis.path, "AdvAnalysisReport.html"))
  
  # Create an include file that tells the report to not display the "Share" menu
  incFilePath <- file.path(path.inc, "share.js")
  incFile <- file(incFilePath)
  writeLines(c("var shareButton = false;"), incFile)
  close(incFile)

  # Create a zip for sharing the report.
  packageReport(
    report = advAnalysisReport,
    outputPath = file.path(analysis.path, "AdvAnalysisReport.html"))
  
  # Create an include file that tells the report to display the "Share" menu
  file.remove(incFilePath)
  incFile <- file(incFilePath)
  writeLines(c("var shareButton = true;"), incFile)
  close(incFile)
  
  cat("document.write('<p>Finished writing analysis report </p>');", file=paste(path.inc,"//status.js",sep=""),append=TRUE)
  
  ### return to working directory:
  setwd(tempwd)
  
}