
# Pipeline
#---------
path.pipeline.base <- "C://Users//ahossein//Application Data//nSolver2//pipelines//r//PanCancerImmunology"
# remove
#path.pipeline.base <- "C://Users//John Bucci//AppData//Roaming//nSolver3//pipelines//r//PanCancerImmunology"

# General options
#----------------
plottypearg <- "png"

# Input/Output
#-------------
advanced.analysis.name <- "tstrun"
data.type <- "raw"
path.results.copy <- "./output_here/copyhere"
path.data <- c("./Data//ProcessedData.csv", 
               "./Data//RawData.csv",
               "./Data//BackgroundSubtractedValues.csv",
               "./Data//KEGG.ID.map.csv")


path.sampleannot <- "./Data/SampleAnnotations.csv"
path.geneannot   <- "./Data/ProbeAnnotations.csv"


# Sample annotations
#-------------------
sample.annotation.id.column <- "smp.ID"
sampleannot.variabletypes <- c("categorical","categorical", "continuous", "categorical")
sampleannot.variables <- c("smp.names","cell.type", "t", "trt")
sampleannot.referencelevels <- c("Jurkat 100K_50K-1","Jurkat", NA, "no")
min.sample.covariate <- 1


# Probe annotations
#------------------
gene.annotation.id.column <- "UniqueID"          #<-------------This may become static as opposed to user input
probe.annotation.KEGG.id.column <- "KEGG.Pathways" #<-------------This may become static as opposed to user input
probe.annotation.KEGG.Gene.Name <-  "Gene.Name"    #<-------------This may become static as opposed to user input
probe.annotation.celltype.id.column <- "Cell.Type" #<-------------This may become static as opposed to user input
# probeannot.variabletypes <- NULL
# probeannot.referencelevels <- NULL
# probeannot.variables <- NULL
probe.set.column <- "Probe.Annotation"
min.probe.covariate <- 40
min.KEGG.set.size <- 50


# Normalization
#--------------
normmodule.analytes.run <- c("mRNA","protein")
normmodule.norm.probes <- NULL
normmodule.nchoos <- list(mRNA = "Dynamic",protein = 10)

# normmodule.arg.run <- TRUE
# #normmodule.arg.method <- "choose HKs"
# normmodule.arg.n.HKs <- NULL
# normmodule.arg.auto.HKs <- TRUE
# normmodule.arg.candidate.HK.column <- "is.HK"
# 
# protnormmodule.arg.run <- TRUE
# protnormmodule.arg.n.HKs <- NULL
# protnormmodule.arg.auto.HKs <- TRUE
# protnormmodule.arg.candidate.HK.column <- "is.HK"


# QC module
#----------
QCmodule.arg.run <- TRUE


# DE module
#----------
DEmodule.arg.run <- TRUE
DEmodule.arg.pruneprobes <- FALSE
DEmodule.arg.pruneprobes.bg.level <- 20
DEmodule.arg.pruneprobes.missing.freq <- 0.5
DEmodule.arg.predictors <- "trt"
DEmodule.arg.confounders <- "cell.type"
DEmodule.arg.pval.adjustment <- "BY"


# Pathview module
#----------------
pathviewmodule.arg.run <- TRUE
pathviewmodule.arg.view.colorscheme <- "DE"
pathviewmodule.arg.pvalthres <- 0.05
#pathviewmodule.arg.keggIDs <- c("04660","04662","04650","04612","04151","04060")
#pathviewmodule.arg.keggnames <- c("T-Cell receptors","B-cell receptors","NK cytotoxicity","Antigen processing","PI3K-AKT","04060")


# Geneset module
#---------------
gsamodule.arg.run <- TRUE



# CT.arg.run <- TRUE
# CT.arg.backgroundthreshold <- 30


# Immune profile module
#----------------------
celltypes.arg.run <- TRUE
celltypes.arg.covariates <- "cell.type"
celltypes.arg.column <- "Cell.Type"
celltypes.arg.probeselection <- "DynamicallySelect"
celltypes.arg.pvalthreshold <- 1.00
celltypes.arg.showraw <- TRUE
celltypes.arg.showrelative <- TRUE
celltypes.arg.usedefault <- TRUE


# Pathway scoring module
#----------------------

#sampleannot.variables <- c("smp.names","cell.type", "t", "trt")
#sampleannot.referencelevels <- c("Jurkat 100K_50K-1","Jurkat", NA, "no")

### temporary argument values:
pathscores.arg.run = TRUE
pathscores.arg.method = "PC1"
pathscores.arg.gene.sets.list = NULL
pathscores.arg.adjust.for = c("cell.type")
pathscores.arg.covariates=c("trt")
pathscores.arg.covariates.type="categorical"


#deregmodule.arg.run <- FALSE
#deregmodule.arg.method <- "PC1"
#deregmodule.arg.is.normal.variable <- NULL
#deregmodule.arg.is.normal.level <- NULL
#deregmodule.arg.adjust.for <- NULL
#deregmodule.arg.covariates <- NULL


# SPD module
#-----------
SPDarg.select.probe.analysis.run <- TRUE
SPDarg.probe.names.to.describe <- c("NM_014339.6:482",  "NM_032965.3:112",  "nProt_00061:1",    "NM_006564.1:95",   "NM_031200.1:1095", "nProt_00064:1" )
SPDarg.describe.probes.by <- c("trt","cell.type")
SPDarg.order.expression.trend.by <- "t"
SPDarg.trend.expression.by <- "smp.names"
SPDarg.stratify.expression.trend.by <- "trt"
SPDarg.interactnet.adjustfor <- c() # 
SPDarg.interactnet.stratifyby <- c() # must be categorical


# mulitomics module
#------------------
RPDarg.run <- TRUE  # rule: if we have a probe annotation column with the right name, we use it
RPDarg.rp.identifier.column <- "Related.Probes"
RPDarg.describe.probes.by <- c("trt","cell.type")
RPDarg.order.expression.trend.by <- "t"
RPDarg.trend.expression.by <- "smp.names"
RPDarg.stratify.expression.trend.by <- "trt"
RPDarg.interactnet.adjustfor <- c()
RPDarg.interactnet.stratifyby <- c()

# next four: get from the SGD arguments
#multiomicsarg.describe.probes.by <- "Subtype.Call"
#multiomicsarg.order.expression.trend.by <- "NULL"
#multiomicsarg.trend.expression.by <- "NULL"
#multiomicsarg.stratify.expression.trend.by <- "NULL"


