﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
  <xsl:output method="html" version="4.0" indent="yes" omit-xml-declaration="yes"/>
  <xsl:variable name="apos">'</xsl:variable>
  
  <xsl:template match="/">
    <xsl:text disable-output-escaping='yes'>&lt;!DOCTYPE html></xsl:text>
    <xsl:comment>
      <xsl:text disable-output-escaping='yes'>[if IE 9]>&lt;html class="lt-ie10" lang="en" > &lt;![endif]</xsl:text>
    </xsl:comment>
    <xsl:comment>
      <xsl:text disable-output-escaping='yes'>[if IE 10]>&lt;html class="ie10" lang="en" > &lt;![endif]</xsl:text>
    </xsl:comment>
    <html class="no-js" lang="en" >
      <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <title>nCounter Advanced Analysis Report</title>
        <meta name="author" content="NanoString Technologies"/>
        <link rel="stylesheet" href="resources/css/normalize.css"/>
        <link rel="stylesheet" href="resources/css/foundation.css"/>
        <link rel="stylesheet" href="resources/css/jquery.dataTables.min.css"/>
        <link rel="stylesheet" href="resources/css/jquery-ui.css"/>
        <link rel="stylesheet" href="resources/css/theme.css"/>
        <link rel="stylesheet" href="resources/css/report.css"/>

        <script src="resources/js/modernizr.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/jquery.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/jquery-ui.min.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/fastclick.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/foundation.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/foundation.tab.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/foundation.topbar.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/foundation.dropdown.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/jquery.dataTables.min.js"><xsl:text> </xsl:text></script>
        <script src="resources/js/report.js"><xsl:text> </xsl:text></script>
        <script src="resources/inc/share.js"><xsl:text> </xsl:text></script>

        <link rel="shortcut icon" type="Image/x-icon" href="resources/img/nanostring_icon.png"/>

        <meta class="foundation-data-attribute-namespace"/>
        <meta class="foundation-mq-xxlarge"/>
        <meta class="foundation-mq-xlarge"/>
        <meta class="foundation-mq-large"/>
        <meta class="foundation-mq-medium"/>
        <meta class="foundation-mq-small"/>
        <meta class="foundation-data-attribute-namespace"/>
        <meta class="foundation-mq-xxlarge"/>
        <meta class="foundation-mq-xlarge"/>
        <meta class="foundation-mq-large"/>
        <meta class="foundation-mq-medium"/>
        <meta class="foundation-mq-small"/>
        <meta class="foundation-mq-topbar"/>
        <meta class="foundation-mq-topbar"/>
        <meta class="foundation-mq-topbar"/>
      </head>
      <body>
        <!--Top Menu-->
        <!--Assumption is made in this stylesheet that the first HorizontalMenu will be a "Top Bar"-->
        <xsl:apply-templates select="AdvAnalysisReport/Content/HorizontalMenu[1]" mode="TopBar" />
        
        <!--Content Panel(s) for Top Bar menu items -->
        <div class="row">
          <xsl:apply-templates select="AdvAnalysisReport/Content/HorizontalMenu[1]" mode="MenuItemContent"/>
        </div>


        <script>
          $(document).foundation();
        </script>
        <script>
          $(document).ready(function() {

          // Initialize all of the data tables
          $('table.display').dataTable( {
          "order": []
          } );

          // Hide share button if the inc file isn't there
          if (!shareButton) {
          $(".share-report").hide();
          }

          $(".image_pop_up").on("click", function() {
          $(".ui-dialog-content").dialog("close");
          });

          // Adjust the text on each active drop-down
          $(".f-dropdown li.active a").each(function( index ) {
          var newActive = $('[data-dropdown="' + $(this).closest('ul').attr('id') + '"]');

          if (newActive.attr('title') != $(this).text()) {
          newActive.text(newActive.attr('title') + ': ' + $(this).text().replace(newActive.attr('title'), ""));
          }
          else{
          newActive.text($(this).text());
          }

          });

          // Make top-bar behave like a tab controls - activate on click
          $('section.top-bar-section ul.right li').click(function() {
          if (!$(this).hasClass("share-report")) {
          $('section.top-bar-section ul.right li').removeClass('active');
          $(this).addClass("active");
          }
          });

          // Hide's the drop-down after it's clicked and add active to its 'parent' button
          $(".f-dropdown").on("click", function(){
          $(this).closest('ul').removeClass('open').css('left', '-9999px');
          });

          // When a drop-down's child is clicked, set its parent buttons text
          $(".f-dropdown li a").on("click", function(){

          // Sync the other drop-downs that have the same name...
          var matchingNodes = $('.f-dropdown li a[menuindex="' + $(this).attr('menuindex') + '"]');

          jQuery.each(matchingNodes, function(i, val) {
          var hrefText = val.href.substring(val.href.indexOf('#'));
          $(hrefText).siblings().removeClass('active')
          $(hrefText).addClass('active');

          var previousActive = $('*[data-dropdown="' + $(this).closest('ul').attr('id') + '"]').closest('dl').find('li a.active');
          previousActive.removeClass('active');
          previousActive.text(previousActive.attr('title'));

          var newActive = $('[data-dropdown="' + $(this).closest('ul').attr('id') + '"]');

          if (newActive.attr('title') != $(this).text()) {
          newActive.text(newActive.attr('title') + ': ' + $(this).text().replace(newActive.attr('title'), ""));
          }
          else{
          newActive.text($(this).text());
          }

          newActive.addClass('active');

          });
          });

          // Sync all sub-navs with the same name and activate the matching content
          $('dl.sub-nav li a').on('click', function(){

          var menuName = $(this).attr('menuindex').split("|")[0];

          $("dl.sub-nav li a[menuindex^='" + menuName + "|']").parent().removeClass('active');
          $("dl.sub-nav li a[menuindex^='" + menuName + "|']").parent().parent().siblings('div.tabs-content').children('div.content.active').removeClass('active');

          var matchingNodes = $('dl.sub-nav li a:contains(' + $(this).text() + ')');
          matchingNodes.parent().addClass('active');

          jQuery.each(matchingNodes, function(i, val) {
          var hrefText = $(this).attr('href');
          $(hrefText).addClass('active');
          });

          });

          });
        </script>


      </body>
    </html>
  </xsl:template>


  <!--=============================================================================-->
  <!-- Top Bar -->
  <xsl:template match="HorizontalMenu" mode="TopBar">
    <nav class="top-bar" data-topbar="" data-options="is_hover: false" role="navigation">
      <ul class="title-area">
        <li class="name">
          <h1>
            <a href="http://www.nanostring.com"><img src="resources/img/logo_nanostring_white_Flat_189x40.png"></img></a>
          </h1>
        </li>
      </ul>

      <section class="top-bar-section">
        <ul class="right">
          <xsl:apply-templates/>
          <li class="share-report">
            <a href="AdvAnalysisReport.zip">Share</a>
          </li>
        </ul>

      </section>

    </nav>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Sub Nav  - Horizontal menu within a panel's contents -->
  <xsl:template match="HorizontalMenu" >
    <xsl:choose>
      <xsl:when test="(not(preceding-sibling::HorizontalMenu)) and (following-sibling::HorizontalMenu)">
        <dl class="button-group radius">
          <xsl:apply-templates select="../HorizontalMenu" mode="DropDownMenu" />
        </dl>

        <xsl:apply-templates select="../HorizontalMenu" mode="DropDownMenuList" />
        
        <div class="tabs-content">
          <xsl:apply-templates select=".." mode="TabContent"/>
        </div>
      </xsl:when>
      <xsl:when test="(preceding-sibling::HorizontalMenu) | (following-sibling::HorizontalMenu)">
        <!--Ignore these nodes, since they were already rendered by the templates called above...-->
      </xsl:when>
      <xsl:otherwise>
        <dl class="sub-nav" data-tab="">
          <dt>
            <xsl:value-of select="concat(@Title, ':')"/>
          </dt>
          <xsl:apply-templates mode="TabItem"/>
        </dl>
        <div class="tabs-content">
          <xsl:apply-templates mode="TabContent"/>
        </div>        
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Vertical Menu - assumed to be within a panel's contents -->  
  <xsl:template match="VerticalMenu">
    <!--<div class="row">-->
      <div class="small-2 columns">
    
        <ul class="tabs vertical" data-tab="">
          <p>
            <xsl:value-of select="concat(@Title, ':')"/>
          </p>          
          <xsl:apply-templates mode="VerticalMenuItem"/>
        </ul>
      </div>
      <div class="tabs-content">
        <xsl:apply-templates mode="TabContent"/>
      </div>
    <!--</div>-->
  </xsl:template>

  <!--=============================================================================-->
  <!-- Horizontal drop-down menu -->
  <xsl:template match="HorizontalMenu" mode="DropDownMenu">
    <xsl:element name="li">
      <xsl:element name="a">
        <xsl:attribute name="class">
          <xsl:text>small button</xsl:text>
          <xsl:if test="Content/MenuItem/@Active='True'">
            <xsl:text> active</xsl:text>
          </xsl:if>
        </xsl:attribute>
        <xsl:attribute name="href">
          <xsl:text>#</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="data-dropdown">
          <xsl:value-of select="concat('drop-', @Id)"/>
        </xsl:attribute>
        <xsl:attribute name="title">
          <xsl:value-of select="@Title"/>
        </xsl:attribute>
        <xsl:value-of select="@Title"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>  
  
  <!--=============================================================================-->
  <!-- Horizontal drop-down menu - main template -->
  <xsl:template match="HorizontalMenu" mode="DropDownMenuList">
    <xsl:element name="ul">
      <xsl:attribute name="id">
        <xsl:value-of select="concat('drop-', @Id)"/>
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:text>content f-dropdown</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-dropdown-content" />
      <xsl:attribute name="data-tab" />
      <xsl:comment>
        <xsl:text>Drop-down menu - This comment is a workaround for an apparent bug with empty elements not closing.</xsl:text>
      </xsl:comment>
      <xsl:apply-templates mode="TabItem" />
    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Image content -->
  <xsl:template match="Image">
    <xsl:element name="li">
      <p>
        <b>
          <xsl:value-of select="@Title"/>
          <br />
          <xsl:if test="./Content/Annotation">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="onclick">
                <xsl:value-of select="concat('openPopup(', $apos, ./Content/Annotation/@Id, '_', @Id, $apos, ');return false;')"/>
              </xsl:attribute>
              <span class="label round" >More Plot Information</span>
            </xsl:element>
          </xsl:if>
          <xsl:if test="./Content/FileDownloadLink">
            <xsl:apply-templates select="./Content/FileDownloadLink"/>
          </xsl:if>          
        </b>
      </p>
      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:text>#</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="onclick">
          <xsl:value-of select="concat('openImagePopup(', $apos, @Id, $apos, ');return false;')"/>
        </xsl:attribute>
        <xsl:element name="div">
          <xsl:attribute name="class">
            <xsl:choose>
              <xsl:when test="./Content/Legend">
                <xsl:text>small-9 columns</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>small-12 columns</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:element name="image">
            <xsl:attribute name="src">
              <xsl:value-of select="@uri"/>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>

        <xsl:if test="./Content/Legend">
          <div class="small-3 columns">
            <xsl:apply-templates select="./Content/Legend" />
          </div>
        </xsl:if>
      </xsl:element>

      
      <!--Image xtra large modal-->
      <xsl:element name="div">
        <xsl:attribute name="id">
          <xsl:value-of select="@Id"/>
        </xsl:attribute>
        <xsl:attribute name="class">
          <xsl:text>image_pop_up</xsl:text>
        </xsl:attribute>
        <xsl:element name="div">
          <xsl:attribute name="class">
            <xsl:choose>
              <xsl:when test="./Content/Legend">
                <xsl:text>image_pop_up_content small-10 columns</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>image_pop_up_content small-12 columns</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:element name="img">
            <xsl:attribute name="src">
              <xsl:value-of select="@uri"/>
            </xsl:attribute>
            <xsl:attribute name="style">
              <xsl:text>width: 100%;</xsl:text>
            </xsl:attribute>
          </xsl:element>
        </xsl:element>
        <xsl:if test="./Content/Legend">
          <div class="small-2 columns">
            <xsl:apply-templates select="./Content/Legend" />
          </div>
        </xsl:if>
      </xsl:element>

      <!--Image annotation modal-->
      <xsl:if test="./Content/Annotation">
        <xsl:element name="div">
          <xsl:attribute name="id">
            <xsl:value-of select="concat(./Content/Annotation/@Id, '_', @Id)"/>
          </xsl:attribute>
          <xsl:attribute name="class">
            <xsl:text>annotation_pop_up</xsl:text>
          </xsl:attribute>
          <h5>
            <xsl:value-of select="@Title"/>
          </h5>
          <p>
            <xsl:value-of select="./Content/Annotation/@Title"/>
          </p>
        </xsl:element>
      </xsl:if>

    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- File Download Link -->
  <xsl:template match="FileDownloadLink">
    <xsl:text>&#160;&#160;</xsl:text>
    <xsl:element name="a">
      <xsl:attribute name="href">
        <xsl:value-of select="@uri"/>
      </xsl:attribute>
      <xsl:element name="span">
        <xsl:attribute name="class">
          <xsl:text>label round</xsl:text>
        </xsl:attribute>
        <xsl:value-of select="@Title"/>
      </xsl:element>
    </xsl:element>    
  </xsl:template>

  <!--=============================================================================-->
  <!-- Legend Image-->
  <xsl:template match="Legend">
    <xsl:element name="image">
      <xsl:attribute name="src">
        <xsl:value-of select="@uri"/>
      </xsl:attribute>
    </xsl:element>    
  </xsl:template>

  <!--=============================================================================-->
  <!-- Table -->
  <xsl:template match="Table">
    <xsl:element name="li">
      <p>
        <b>
          <xsl:value-of select="@Title"/>
          <br />
          <xsl:if test="./Content/Annotation">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:text>#</xsl:text>
              </xsl:attribute>
              <xsl:attribute name="onclick">
                <xsl:value-of select="concat('openPopup(', $apos, ./Content/Annotation/@Id, '_', @Id, $apos, ');return false;')"/>
              </xsl:attribute>
              <span class="label round" >More Plot Information</span>
            </xsl:element>
          </xsl:if>
          <xsl:if test="./Content/FileDownloadLink">
            <xsl:apply-templates select="./Content/FileDownloadLink"/>
          </xsl:if>
        </b>
      </p>

      <xsl:element name="table">
        <xsl:attribute name="id">
          <xsl:value-of select="@Id"/>
        </xsl:attribute>
        <xsl:attribute name="class">
          <xsl:text>display</xsl:text>
        </xsl:attribute>
        <xsl:attribute name="cellspacing">
          <xsl:text>0</xsl:text>
        </xsl:attribute>
        <xsl:copy-of select="node()"/>
      </xsl:element>

      <!--Table annotation modal-->
      <xsl:if test="./Content/Annotation">
        <xsl:element name="div">
          <xsl:attribute name="id">
            <xsl:value-of select="concat(./Content/Annotation/@Id, '_', @Id)"/>
          </xsl:attribute>
          <xsl:attribute name="class">
            <xsl:text>annotation_pop_up</xsl:text>
          </xsl:attribute>
          <h5>
            <xsl:value-of select="@Title"/>
          </h5>
          <p>
            <xsl:value-of select="./Content/Annotation/@Title"/>
          </p>
        </xsl:element>
      </xsl:if>   
      
    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Paragraph -->
  <xsl:template match="Paragraph">
    <p>
      <xsl:copy-of select="node()"/>
    </p>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Heading -->
  <xsl:template match="Heading">
    <h5>
      <b>
        <xsl:value-of select="@Title"/>
      </b>
    </h5>
  </xsl:template>
  
  <!--=============================================================================-->
  <!-- Menu Content-->
  <xsl:template match="Panel" mode="MenuItemContent">
    <xsl:element name="div">
      <xsl:attribute name="id">
        <xsl:value-of select="@Id"/>
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:text>panelContent</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="(../../@Active='True')">
            <xsl:text>display:block</xsl:text>            
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>display:none</xsl:text>    
          </xsl:otherwise>          
        </xsl:choose>
      </xsl:attribute>
      <div class="row">
        <div class="panel">
          <p>
            <xsl:value-of select="@Title"/>
          </p>
        </div>
      </div>

      <xsl:choose>
        <xsl:when test="Content/VerticalMenu">
          <div class="row">
            <div class="small-12 columns">
              <xsl:apply-templates />
            </div>
          </div>
        </xsl:when>
    
        <xsl:otherwise>
          <div class="row">
            <div class="panel">
              <xsl:element name="ul">
                <xsl:attribute name="class">
                  <xsl:choose>
                    <xsl:when test="number(./Content/@Count) > 1">
                      <xsl:value-of select="concat('small-block-grid-', number(./Content/@Count)-1, ' medium-block-grid-', ./Content/@Count)"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="concat('small-block-grid-', ./Content/@Count)"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:attribute>
                <xsl:apply-templates />
              </xsl:element>
            </div>
          </div>
        </xsl:otherwise>

      </xsl:choose>
    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Tab Content-->
  <xsl:template match="Panel" mode="TabContent">
    <xsl:element name="div">
      <xsl:attribute name="id">
        <xsl:value-of select="@Id"/>
      </xsl:attribute>
      <xsl:attribute name="class">
        <xsl:text>content</xsl:text>
        <xsl:if test="(../../@Active='True')">
          <xsl:text> active</xsl:text>
        </xsl:if>
      </xsl:attribute>

      <xsl:element name="div">
        <xsl:attribute name="class">
          <xsl:choose>
            <xsl:when test="../../../../../VerticalMenu">
              <xsl:text>small-10 columns</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>small-12 columns</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:attribute>
        <xsl:element name="ul">
          <xsl:attribute name="class">
            <xsl:choose>
              <xsl:when test="number(./Content/@Count) > 1">
                <xsl:text>small-block-grid-1 medium-block-grid-2</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>small-block-grid-1</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:attribute>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:element>

    </xsl:element>
  </xsl:template>

 
  <!--=============================================================================-->
  <!-- Menu Item-->
  <xsl:template match="MenuItem">
    <xsl:element name="li">
      <xsl:if test="(@Active='True')">
        <xsl:attribute name="class">
          <xsl:text>active</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:value-of select="concat('javascript:ShowContent(', $apos, Content/Panel/@Id, $apos, ')')"/>
        </xsl:attribute>
        <xsl:value-of select="@Title"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Tab Item-->
  <xsl:template match="MenuItem" mode="TabItem">
    <xsl:element name="li">
      <xsl:if test="(@Active='True')">
        <xsl:attribute name="class">
          <xsl:text>active</xsl:text>
        </xsl:attribute>
      </xsl:if>
      <xsl:element name="a">
        <xsl:attribute name="menuindex">
          <xsl:value-of select="concat(../../@Title, '|', @Title)"/>
        </xsl:attribute>
        <xsl:attribute name="href">
          <xsl:value-of select="concat('#', Content/Panel/@Id)"/>
        </xsl:attribute>
        <xsl:value-of select="@Title"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <!--=============================================================================-->
  <!-- Vertical Menu Item-->
  <xsl:template match="MenuItem" mode="VerticalMenuItem">
    <xsl:element name="li">
      <xsl:attribute name="class">
        <xsl:text>tab-title</xsl:text>
        <xsl:if test="(@Active='True')">
          <xsl:text> active</xsl:text>
        </xsl:if>
      </xsl:attribute>
      
      
      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:value-of select="concat('#', Content/Panel/@Id)"/>
        </xsl:attribute>
        <xsl:value-of select="@Title"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>  
  
</xsl:stylesheet>