



##########################################################################################
# function to write a results menu structure that aligns with covariate sructure (levels of cat variables become dropdowns)

##########################################################################################
# function to write a results menu structure that aligns with covariate sructure (levels of cat variables become dropdowns)

## define the variables for which results will be returned: 
#   everything in DEmodule.arg.predictors that also appears in dimnames(DEresults$ests)
# rule:
#       1) cont variables get their own tab, 
#       2) cat variables are combined with their levels to get resultsnames
#       3) anything not captured by the above gets its own tab

### object names:
# main panel: paste("panel_",resultname,sep="")
# horiz menus - one for each result: correspond to covariates:  paste(resultname,"-horizmenu-", sampleannot.variables.to.use[i], sep = "")
# dropdowns menus from tabs (if they exist): correspond to covariates: paste(resultname,"-dd-", sampleannot.variables.to.use[i], sep = "")
# dropdowns menu elements: correspond to levels: paste(resultname,"-ddelement-", tempname, sep = "")
# panels containing results (and possibly vert menus):    paste(resultname,"-resultpanel-",tempname, sep = "")


# debugging lines:
#id.modulemenu = "moduleMenu_DiffExpr"
#resultname = "DE"
#reportobject = advAnalysisReport
#resultvarnames = dimnames(DEresults$ests)[[2]]
#sampleannot.variables.to.use = "subtype"
#title = "Pathview filler."


# id.report: the advanced analysis report ID to write to
# id.modulemenu: the element of the module menu to write to (though could point to any object if needed)

writeCovariatesMenu = function(reportobject,id.modulemenu,resultname,resultvarnames,
                               sampleannot.variables.to.use,sampleannot.variabletypes,sampleannot.referencelevels,annot,title,newtermnames=NULL)
{
  addReportContent(
    element = getReportContentById(id = id.modulemenu, report = reportobject),
    
    # Add a panel
    panel(
      id = paste("panel_",resultname,sep=""),
      title = title
      )    
  )   
  
  # names of contrasts for which we've written results:
  resultvarnames.written = c()
  
  ### step 1) for each predictor, check that it has results, then write an upper tab
  for(i in 1:length(sampleannot.variables.to.use))
  {
#   if(sampleannot.variabletypes[sampleannot.variables.to.use[i]]=="continuous")
    if(sampleannot.variabletypes[sampleannot.variables.to.use[i]]=="continuous")
    {
      # check that there's a result matching it:
      if(is.element(sampleannot.variables.to.use[i],resultvarnames))
      {
        tempname = sampleannot.variables.to.use[i]
        # Add a horiz menu to the main panel:
        addReportContent(
          element = getReportContentById(id = paste("panel_",resultname,sep=""), report = reportobject),
          horizontalMenu(id = paste(resultname,"-horizmenu-", sampleannot.variables.to.use[i], sep = ""), title = tempname)
        )      
        # add a single menu item to it:
        addReportContent(
          element = getReportContentById(id = paste(resultname,"-horizmenu-", sampleannot.variables.to.use[i], sep = ""), report = reportobject),
          menuItem(id = paste(resultname,"-menuitem-", sampleannot.variables.to.use[i], sep = ""), title = tempname)
        ) 
        
        # write the panel of results:
        addReportContent(
          element = getReportContentById(id = paste(resultname,"-menuitem-", sampleannot.variables.to.use[i], sep = ""), report = reportobject),
          
          # Add a panel - the current stylesheet groups each menu item's content into panels, so this is required by that 
          # implementation.
          panel(
            #id = paste("deMenu-", tempname, sep = ""), 
            id = paste(resultname,"-resultpanel-",tempname, sep = "")#, 
            
            ## Add an image to the panel
            #reportImage(
            #  id = paste("DEvolcano",tempname), 
            #  href=paste(path.results,"/DE/volcano plot",tempname,".png",sep=""), 
            #  title = paste("Volcano plot:",tempname)),
            # Add the results table: <-------------
            
          )
        )
        # add the result name to the list of what's been written:
        resultvarnames.written = c(resultvarnames.written,tempname)
      }
    }
#   if(sampleannot.variabletypes[sampleannot.variables.to.use[i]]=="categorical")
    if(sampleannot.variabletypes[sampleannot.variables.to.use[i]]=="categorical")
    {
      #tempname = sampleannot.variables.to.use[i]
      # Add a horiz menu to the main panel:
      addReportContent(
        element = getReportContentById(id = paste("panel_",resultname,sep=""), report = reportobject),
        horizontalMenu(id = paste(resultname,"-horizmenu-", sampleannot.variables.to.use[i], sep = ""), title = sampleannot.variables.to.use[i])
      )    
      # get levels: 
      levels = setdiff(levels(annot[,sampleannot.variables.to.use[i]]),sampleannot.referencelevels[sampleannot.variables.to.use[i]])
      tempnames = paste(sampleannot.variables.to.use[i],levels,sep="")
      # isolate the levels that we have results for:
      delete = !is.element(tempnames,resultvarnames)
      tempnames = tempnames[!delete]
      levels = levels[!delete]
      # make each level a menu item:
      if(length(tempnames)>=1)
      {      
        # for each level:
        for(j in 1:length(tempnames))
        {
          tempname = tempnames[j]
          temptitle = tempname
          if(length(newtermnames)>0)
          {
            if(is.element(tempname,names(newtermnames)))
            {
              temptitle = newtermnames[tempname]
            }
          }
          # check that there's a result matching it:
          if(is.element(tempname,resultvarnames))
          {
            # Add a menu item to the menu we created above
            addReportContent(
              element = getReportContentById(id = paste(resultname,"-horizmenu-", sampleannot.variables.to.use[i], sep = ""), report = reportobject),
              menuItem(id = paste(resultname,"-menuitem-", tempname, sep = ""), title = temptitle)
            ) 
            
            # write the content:
            addReportContent(
              element = getReportContentById(id = paste(resultname,"-menuitem-", tempname, sep = ""), report = reportobject),
              
              # Add a panel - the current stylesheet groups each menu item's content into panels, so this is required by that 
              # implementation.
              panel(
                #id = paste("deMenu-", tempname, sep = ""), 
                id = paste(resultname,"-resultpanel-",tempname, sep = "")
                #href = "temporarynonsense",
                
                ## Add an image to the panel
                #reportImage(
                #  id = paste("DEvolcano",tempname), 
                #  href=paste(path.results,"/DE/volcano plot",tempname,".png",sep=""), 
                #  title = paste("Volcano plot:",tempname))
                
                ## Add the results table: <-------------
                
              )
            )
                  
            # add the result name to the list of what's been written:
            resultvarnames.written = c(resultvarnames.written,tempname)
          }
        }
      }
    }
  }
  # now for any results that don't have a tab yet, make one:
  omittedvars = setdiff(resultvarnames,resultvarnames.written)
  if(length(omittedvars)>0)
  {
    for(i in 1:length(omittedvars))
    {
      tempname = omittedvars[i]
      # Add a horiz menu to the main panel:
      addReportContent(
        element = getReportContentById(id = paste("panel_",resultname,sep=""), report = reportobject),
        horizontalMenu(id = paste(resultname,"-horizmenu-", tempname, sep = ""), title = tempname)
      )      
      # add a single menu item to it:
      addReportContent(
        element = getReportContentById(id = paste(resultname,"-horizmenu-", tempname, sep = ""), report = reportobject),
        menuItem(id = paste(resultname,"-menuitem-", tempname, sep = ""), title = tempname)
      ) 
      
      # write the panel of results:
      addReportContent(
        element = getReportContentById(id = paste(resultname,"-horizmenu-", tempname, sep = ""), report = reportobject),
        
        # Add a panel - the current stylesheet groups each menu item's content into panels, so this is required by that 
        # implementation.
        panel(
          #id = paste("deMenu-", tempname, sep = ""), 
          id = paste(resultname,"-resultpanel-",tempname, sep = ""), 
          
          ## Add an image to the panel
          #reportImage(
          #  id = paste("DEvolcano",tempname), 
          #  href=paste(path.results,"/DE/volcano plot",tempname,".png",sep=""), 
          #  title = paste("Volcano plot:",tempname)),
          # Add the results table: <-------------
          
        )
      )
    }
  }
}




###### 
# function to write a vertical menu and populate it with buttons and panels:
writeandpopulateverticalmenu = function(reportobject,element.id,buttonnames,menuname,buttonprefix,panelsuffix,main.title=NULL,menu.title=NULL,makepanels=TRUE)
{
  # create the menu:
  addReportContent(
    element = getReportContentById(id = element.id, report = reportobject),  
    
    # Add a panel
    #panel(
    #  id = paste("panel for",element.id),
    #  title = main.title, 
      
      # Add the pathways vertical menu... 
      verticalMenu(id = paste(menuname, buttonprefix, sep=""), title = menu.title)
      
    #)
  )
  
  # for each element:
  for(i in 1:length(buttonnames))
  {
    # create a button:
    addReportContent(
      element = getReportContentById(id = paste(menuname, buttonprefix, sep=""), report = reportobject),  
      menuItem(id = paste(menuname,buttonprefix, buttonnames[i], sep = ""),active=(i==1),title = buttonnames[i])
    )
    if(makepanels)
    {
      # add a panel to the button:
      addReportContent(
        element = getReportContentById(id = paste(menuname,buttonprefix, buttonnames[i], sep = ""), report = reportobject),
        panel(
          id = paste(menuname,buttonprefix,buttonnames[i],panelsuffix, sep = "")
        )
      )
    }
  }
}