#=============================================================================================
# This function appends the PD results to the report
# Dependencies: it sources "advanced_analysis_report.r
#=============================================================================================

# Given a report, generate PD report and append to given report
# @ advAnalysisReport: the current report the PD report is to be appended to
# @ results.dir: a list containig the directories of the results 

append.RPD.report <- function(advAnalysisReport, results.dir, module.menue.name,prb.annots)
{
  source("./R_source/advanced_analysis_report.r")
  
  # first get probe names
  
  # hard-coded annotation var names
  #--------------------------------
  probe.names <- prb.annots[,"Probe.Label",drop=F]
  rownames(probe.names) <- make.names(rownames(probe.names))
  
  #print("reachedPD")
  # organization:
  # horiz menu: plot types
  # vert menu: covariate depending on the plot type (trend is the one that makes this different)
  # add a panel:
  
  # Eliminate branches with no leaves
  #results.dir <- results.dir[which(unlist(lapply(results.dir,function(x) unlist(lapply(x,length))))>0)]
  keep.branches <- lapply(results.dir,function(x) unlist(lapply(x,length)>0))
  tmp <- results.dir
  for(lev1 in names(tmp)){
    kb.i <- names(keep.branches[[lev1]])[keep.branches[[lev1]]]
    tmp[[lev1]] <- tmp[[lev1]][kb.i]
    if(length(tmp[[lev1]])==0)
      tmp[[lev1]] <- NULL
  }
  #lapply(tmp,function(x) unlist(lapply(x,length)))
  results.dir <- tmp
  
  #Plot type label handling map
  plt.type.label.map <- c("Univariate Plots","Correlation Plots","PCA Biplots","Parallel  Coordinate Plots","Trend Plots", "Interaction Network")
  names(plt.type.label.map) <- c("univar.plots","cor.plots","PCA.biplots","parcor.plots","trend.plots","interactNet.plots")
  
  #   #keep those present
  #   plt.type.label.map <- plt.type.label.map[names(plt.type.label.map) %in% names(results.dir)]
  
  #Plot type annotation text
  plt.type.annot <- list(univar.plots = annotation(id=plt.type.label.map["univar.plots"],title = "Scatter or box/voilin plot visualizes the association of each selected gene relative to the covariate of interest."),
                         cor.plots = annotation(id=plt.type.label.map["cor.plots"],title = "This plot visualizes pairwise co-expression of a set of probes. The diagonal element shows the univariate expression distrubtion of row/column gene. When sample annotation is provided the data is startified and color-coded by sample annotation."),
                         PCA.biplots = annotation(id=plt.type.label.map["PCA.biplots"],title = "This plot visualizes the data on the first three PC axes while also showing the projection of the original axes of the data (i.e. the genes) onto the PC planes. When sample annotation is provided, the data is stratified and color-coded by sample annotaiton."),
                         parcor.plots = annotation(id=plt.type.label.map["parcor.plots"],title = "This plot visualizes up/down regulation of a set of probes in defined subsets relative to one another. Here, expressions are scaled for each genes across all samples."),
                         trend.plots = annotation(id=plt.type.label.map["trend.plots"],title = "This plot visualizes the expression trajectory of a trending variable (e.g. a patient ID, a cancer subtype) typically across time or an ordinal variable. When ordering variable is categorical the default ordering is alphabetical."),
                         interactNet.plots = annotation(id=plt.type.label.map["interactNet.plots"],title = "This plot visualizes a conditional dependency network among the selected probes that best describes the observed data. An edge between two nodes implies that after accounting for all other nodes, there remains an association between the connected nodes."))
  
  
  # moduleMenu_SelectGeneDescriptive is created at the same time as the other top level menus, in order to be
  # able to control its placement.
  
  
  addReportContent(
    element = getReportContentById(id = module.menue.name, report = advAnalysisReport),
    panel(
      id = "RPDresultpanel",
      title = "This module provides descriptive plots for related probe pairs with data stratified by user-defined covariates of interest. When trending covariates are provided, provides trend plots."
    ))
  
  
  
  for(i in 1:length(results.dir)){
    current.content.id <- "RPDresultpanel"
    plt.type.name <- names(results.dir)[i]
    plt.type <- results.dir[[plt.type.name]]
    
    for(annot.i in names(plt.type))
      names(plt.type[[annot.i]]) <- make.names(names(plt.type[[annot.i]]))
    
    # Add report content
    #-------------------
    plt.type.content.id <- paste("RPDhorizmenuitem",gsub("\\.","",plt.type.name),sep="_")
    plt.type.content.lab <- unname(plt.type.label.map[plt.type.name])
    
    # ADD HORIZONTAL MENU
    addReportContent(
      element = getReportContentById(id = current.content.id, report = advAnalysisReport),
      horizontalMenu(id = plt.type.content.id, title = plt.type.content.lab, active = FALSE)
    )
    
    
    
    for(j in 1:length(plt.type)){
      current.content.id <- plt.type.content.id
      smp.annot.name <- names(plt.type)[j]
      
      
      # Add report content
      #-------------------
      smp.annot.content.id <- paste(current.content.id,gsub("\\.","",smp.annot.name),"dropdownmenu",sep="_")
      smp.annot.content.lab <- gsub("\\."," ",smp.annot.name)
      if(length(plt.type)==1) 
        smp.annot.content.lab <- plt.type.content.lab #<- This is just to not have a blank drop down menu when only 1 annotation
      
      
      # ADD DROP DOWN MENU
      addReportContent(
        element = getReportContentById(id = current.content.id, report = advAnalysisReport),
        menuItem(id = smp.annot.content.id, title = smp.annot.content.lab)
      )
      current.content.id <- smp.annot.content.id
      
      # ADD RIGHT PANEL TO DROP DOWN MENU
      smp.annot.panel.content.id <- paste(current.content.id,"panel",sep="_")
      smp.annot.panel.content.lab <- paste(plt.type.label.map[plt.type.name]," for ",gsub("\\."," ",smp.annot.name)," menu",sep="")
      if(length(plt.type)==1)
        smp.annot.panel.content.lab <- paste(gsub("\\."," ",plt.type.label.map[plt.type.name])," menu",sep="")
      
      addReportContent(
        element = getReportContentById(id = current.content.id, report = advAnalysisReport),
        panel(id = smp.annot.panel.content.id, title = smp.annot.panel.content.lab)
      )
      current.content.id <- smp.annot.panel.content.id
      
      set.of.plt <- plt.type[[smp.annot.name]]
      if(length(set.of.plt)>1){
        # ADD VERTICAL MENU TO THE PANEL
        panel.vbuttonMenu.content.id <- paste(current.content.id,"vbuttonMenu",sep="_")
        panel.vbuttonMenu.content.lab <- paste(smp.annot.panel.content.lab)
        
        addReportContent(
          element = getReportContentById(id = current.content.id, report = advAnalysisReport),
          verticalMenu(id = panel.vbuttonMenu.content.id, title = panel.vbuttonMenu.content.lab)
        )
      }
      
      
      for(k in 1:length(set.of.plt)){
        current.content.id <- smp.annot.panel.content.id
        item.2.show.name <- names(set.of.plt)[k]
        item.2.show.path <- set.of.plt[[k]]
        
        # Add report content
        #-------------------
        if(length(set.of.plt)>1){
          current.content.id <- panel.vbuttonMenu.content.id
          panel.vbutton.content.id <- paste(current.content.id,item.2.show.name,sep="_")
          panel.vbutton.content.lab <- ifelse(item.2.show.name %in% rownames(probe.names),probe.names[item.2.show.name,],item.2.show.name)
          addReportContent(
            element = getReportContentById(id = current.content.id, report = advAnalysisReport),
            menuItem(id = panel.vbutton.content.id, title = panel.vbutton.content.lab)
          )
          current.content.id <- panel.vbutton.content.id
          
          panel.vbutton.panel.content.id <- paste(current.content.id,"panel",sep="_")
          panel.vbutton.panel.content.lab <- "vbutton_panel"
          addReportContent(
            element = getReportContentById(id = current.content.id, report = advAnalysisReport),
            panel(id = panel.vbutton.panel.content.id, title = panel.vbutton.panel.content.lab)
          )
          current.content.id <- panel.vbutton.panel.content.id
        }
        
        
        item.2.show.content.id <- paste(current.content.id,item.2.show.name,sep="_")
        item.2.show.content.lab <- plt.type.name
        
        
        addReportContent(
          element = getReportContentById(id = current.content.id, report = advAnalysisReport),
          reportImage(id = item.2.show.content.id, uri=item.2.show.path, title = plt.type.label.map[item.2.show.content.lab],plt.type.annot[[plt.type.name]])    
        )
        
      }#image add loop
      
    }
  }
  
  return(advAnalysisReport)
}
