

##########################################################################################
# Initialize the Advanced Analysis Report object
initAdvAnalysisReport = function(location)
{
  
  # Set path so that VC++ runtime libraries can be found on Windows. 
  # May need a similar statement for Mac OSX for the Mono.NET libraries
  Sys.setenv(PATH = paste(Sys.getenv('PATH'), ';', file.path(path.pipeline.base, 'libs', Sys.getenv('R_ARCH')), sep=''))
  
  # Using rClr library to provide interface to .NET code
  library(rClr)
  
  # Load the Advanced Analysis Report C# Library
  assemblyFile <- file.path(location, "AdvancedAnalysisReportLib.dll")
  assemblyFile <- path.expand(assemblyFile)
  clrLoadAssembly(assemblyFile)
  
  # Create the report objects
  advAnalysisReport <<- clrNew("AdvancedAnalysisReportLib.AdvAnalysisReport")
  paramReport <<- clrNew("AdvancedAnalysisReportLib.AdvAnalysisReport")
    
}

##########################################################################################
# Add content to a specified report element
# If the report object is passed, this will add content to the report's "root"
# Other report elements can be passed such as menuItems or panels
addReportContent = function(..., element)
{
  
  # Add each report element that was passed in the arguments list
  dots <- list(...)
  for (i in seq_along(dots))
  {
    clrCall(element, "AddContent", dots[[i]])
  }
  
  return(element)
  
}

##########################################################################################
# Get report content by its id
getReportContentById = function(id, report)
{
  content = clrCall(report, "GetContentById", id)
  return (content)
  
}


##########################################################################################
# Horizontal Menu
horizontalMenu = function(..., id, title="", visible=TRUE, active=FALSE)
{
 
  # Create a horizontal menu and set its properties
  menu <- clrNew("AdvancedAnalysisReportLib.HorizontalMenu")
  addElement(
    ...,
    reportElement = menu, 
    id = id, 
    uri = "",
    title = title, 
    visible = visible, 
    active = active
    )
  
  return(menu)
  
}



##########################################################################################
# Vertical Menu
verticalMenu = function(..., id, title="", visible=TRUE, active=FALSE)
{
  
  # Create a vertical menu and set its properties
  menu <- clrNew("AdvancedAnalysisReportLib.VerticalMenu")
  addElement(
    ...,
    reportElement = menu, 
    id = id, 
    uri = "",
    title = title, 
    visible = visible, 
    active = active
  )
  
  return(menu)
  
}


##########################################################################################
# Menu Item
menuItem = function(..., id, title="", visible=TRUE, active=FALSE)
{
  
  # Create a menu item and set its properties
  item <- clrNew("AdvancedAnalysisReportLib.MenuItem")
  addElement(
    ...,
    reportElement = item, 
    id = id, 
    uri = "",
    title = title, 
    visible = visible, 
    active = active
    )
  
  return(item)  
}

##########################################################################################
# Panel
panel = function(..., id, title="", visible=TRUE, active=FALSE)
{
  panelElement <- clrNew("AdvancedAnalysisReportLib.Panel") 
  addElement(
    ...,
    reportElement = panelElement,
    id = id,
    uri = "",
    title = title,
    visible = visible,
    active = active
    )
  
  return(panelElement)
}

##########################################################################################
# Image
reportImage = function(..., id, uri, title="", visible=TRUE)
{
  imageElement <- clrNew("AdvancedAnalysisReportLib.Image")
  addElement(
    ...,
    reportElement = imageElement,
    id = id,
    uri = uri,
    title = title,
    visible = visible,
    active = FALSE)
  
  return(imageElement)
}


##########################################################################################
# Table
reportTable = function(..., id, uri, title="", visible=TRUE)
{
  tableElement <- clrNew("AdvancedAnalysisReportLib.Table")
  addElement(
    ...,
    reportElement = tableElement,
    id = id,
    uri = uri,
    title = title,
    visible = visible,
    active = FALSE)
  
  return(tableElement)
}


##########################################################################################
# FileDownloadLink
fileDownloadLink = function(id, uri, title="", visible=TRUE)
{
  linkElement <- clrNew("AdvancedAnalysisReportLib.FileDownloadLink")
  addElement(
    reportElement = linkElement,
    id = id,
    uri = uri,
    title = title,
    visible = visible,
    active = FALSE)
  
  return(linkElement)
}


##########################################################################################
# Annotation
annotation = function(id, title)
{
  annotationElement <- clrNew("AdvancedAnalysisReportLib.Annotation")
  addElement(
    reportElement = annotationElement,
    id = id,
    uri = "",
    title = title,
    visible = TRUE,
    active = FALSE
    )
  return(annotationElement)
}

##########################################################################################
# Image Legend
imageLegend = function(..., id, uri, title="", visible=TRUE)
{
  legendElement <- clrNew("AdvancedAnalysisReportLib.Legend")
  addElement(
    ...,
    reportElement = legendElement,
    id = id,
    uri = uri,
    title = title,
    visible = visible,
    active = FALSE)
  
  return(legendElement)
}


##########################################################################################
# Paragraph
paragraph = function(content)
{
  para <- clrNew("AdvancedAnalysisReportLib.Paragraph")
  addElement(
    reportElement = para,
    id = "",
    uri = "",
    title = content,
    visible = TRUE,
    active = FALSE
  )
   
  return(para)
}


##########################################################################################
# Heading
heading = function(content)
{
  h <- clrNew("AdvancedAnalysisReportLib.Heading")
  addElement(
    reportElement = h,
    id = "",
    uri = "",
    title = content,
    visible = TRUE,
    active = FALSE
  )
  
  return(h)
}

##########################################################################################
# Add Element
addElement = function(..., reportElement, id, title, uri, visible, active)
{
  clrSet(reportElement, "Id", id)
  clrSet(reportElement, "Uri", uri)
  clrSet(reportElement, "Title", title)
  clrSet(reportElement, "Visible", visible)
  clrSet(reportElement, "Active", active)
  
  # Add each child element that was passed in the arguments list
  dots <- list(...)
  for (i in seq_along(dots))
  {
    clrCall(reportElement, "AddContent", dots[[i]])
  }  
  
}

##########################################################################################
# Write Report HTML
writeReportHtml = function(report, xsltPath, outputPath)
{
  xslt <- path.expand(xsltPath)
  output <- path.expand(outputPath)
  
  clrCall(report, "WriteHtml", xslt, output)
}

##########################################################################################
# Write report zip package
packageReport = function(report, outputPath)
{
  output <- path.expand(outputPath)
  
  clrCall(report, "PackageReport", output)
}

